/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.auth;

import jakarta.annotation.Resource;
import org.miaixz.bus.auth.cache.AuthCache;
import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.starter.auth.AuthProperties;
import org.miaixz.bus.starter.auth.AuthProviderService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={AuthProperties.class})
public class AuthConfiguration {
    @Resource
    AuthProperties properties;

    @Bean
    public AuthProviderService authProviderFactory(ExtendCache extendCache) {
        return new AuthProviderService(this.properties, extendCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExtendCache.class})
    @ConditionalOnProperty(name={"bus.auth.cache.type"}, havingValue="default", matchIfMissing=true)
    public ExtendCache authCache() {
        return AuthCache.INSTANCE;
    }
}

