/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.web;

import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.SpringBuilder;
import org.miaixz.bus.spring.env.SpringEnvironmentPostProcessor;
import org.miaixz.bus.spring.web.JsonConverterConfigurer;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;

public class WebMvcConfigurer
extends SpringEnvironmentPostProcessor
implements org.springframework.web.servlet.config.annotation.WebMvcConfigurer {
    private static final List<MediaType> DEFAULT_MEDIA_TYPES = List.of(MediaType.APPLICATION_JSON, MediaType.parseMediaType((String)"text/plain;charset=UTF-8"));
    protected String autoType;

    public WebMvcConfigurer(String autoType) {
        this.autoType = autoType;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.configureConverter(converters, this::configureStringConverter, "StringHttpMessageConverter");
        this.configureJsonConverters(converters, this.getJsonConfigurers());
    }

    private List<JsonConverterConfigurer> getJsonConfigurers() {
        List<JsonConverterConfigurer> configurers = SpringBuilder.getBeansOfType(JsonConverterConfigurer.class).values().stream().peek(configurer -> {
            try {
                configurer.autoType(this.autoType);
                Logger.debug((String)"Set autoType '{}' for custom JsonConverterConfigurer: {}", (Object[])new Object[]{this.autoType, configurer.name()});
            }
            catch (Exception e) {
                Logger.warn((String)"Failed to set autoType for custom JsonConverterConfigurer {}: {}", (Object[])new Object[]{configurer.name(), e.getMessage(), e});
            }
        }).sorted(Comparator.comparingInt(JsonConverterConfigurer::order)).toList();
        Logger.debug((String)"Retrieved {} available custom JsonConverterConfigurer beans: {}", (Object[])new Object[]{configurers.size(), configurers.stream().map(JsonConverterConfigurer::name).toList()});
        return configurers;
    }

    private void configureConverter(List<HttpMessageConverter<?>> converters, Consumer<List<HttpMessageConverter<?>>> configurer, String name) {
        try {
            configurer.accept(converters);
            Logger.info((String)"Successfully configured {} message converter", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            Logger.warn((String)"Failed to configure {}: {}", (Object[])new Object[]{name, e.getMessage(), e});
        }
    }

    private void configureJsonConverters(List<HttpMessageConverter<?>> converters, List<JsonConverterConfigurer> configurers) {
        for (JsonConverterConfigurer configurer : configurers) {
            this.configureConverter(converters, configurer::configure, configurer.name());
        }
    }

    private void configureStringConverter(List<HttpMessageConverter<?>> converters) {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(Charset.UTF_8);
        stringConverter.setSupportedMediaTypes(DEFAULT_MEDIA_TYPES);
        converters.add((HttpMessageConverter<?>)stringConverter);
        Logger.debug((String)"StringHttpMessageConverter configured with media types: {}", (Object[])new Object[]{DEFAULT_MEDIA_TYPES});
    }
}

