/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.web.JsonConverterConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={ObjectMapper.class})
public class JacksonConverterConfigurer
implements JsonConverterConfigurer {
    private String autoType;

    @Override
    public String name() {
        return "Jackson";
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public void configure(List<HttpMessageConverter<?>> converters) {
        Logger.debug((String)"Configuring MappingJackson2HttpMessageConverter with autoType: {}", (Object[])new Object[]{this.autoType});
        ObjectMapper jacksonMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        if (this.autoType != null && !this.autoType.isEmpty()) {
            BasicPolymorphicTypeValidator ptv = BasicPolymorphicTypeValidator.builder().allowIfBaseType(this.autoType).build();
            jacksonMapper.activateDefaultTyping((PolymorphicTypeValidator)ptv, ObjectMapper.DefaultTyping.NON_FINAL);
            Logger.debug((String)"Jackson autoType enabled for package prefix: {}", (Object[])new Object[]{this.autoType});
        }
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(formatter));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(formatter));
        jacksonMapper.registerModule((Module)javaTimeModule);
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter();
        jacksonConverter.setObjectMapper(jacksonMapper);
        jacksonConverter.setSupportedMediaTypes(List.of(MediaType.APPLICATION_JSON, new MediaType("application", "json+jackson")));
        converters.add(this.order(), (HttpMessageConverter<?>)jacksonConverter);
        Logger.debug((String)"Jackson converter configured with media types: {}", (Object[])new Object[]{jacksonConverter.getSupportedMediaTypes()});
    }

    @Override
    public void autoType(String autoType) {
        this.autoType = autoType;
    }
}

