/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.web.JsonConverterConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={Gson.class})
public class GsonConverterConfigurer
implements JsonConverterConfigurer {
    private String autoType;

    @Override
    public String name() {
        return "Gson";
    }

    @Override
    public int order() {
        return 2;
    }

    @Override
    public void configure(List<HttpMessageConverter<?>> converters) {
        Logger.debug((String)"Configuring GsonHttpMessageConverter with autoType: {}", (Object[])new Object[]{this.autoType});
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (this.autoType != null && !this.autoType.isEmpty()) {
            gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new AutoTypeAdapterFactory(this.autoType));
            Logger.debug((String)"Gson autoType enabled for package prefix: {}", (Object[])new Object[]{this.autoType});
        }
        Gson gson = gsonBuilder.create();
        GsonHttpMessageConverter converter = new GsonHttpMessageConverter();
        converter.setGson(gson);
        converter.setSupportedMediaTypes(List.of(MediaType.APPLICATION_JSON, new MediaType("application", "json+gson")));
        converters.add(this.order(), (HttpMessageConverter<?>)converter);
        Logger.debug((String)"Gson converter configured with media types: {}", (Object[])new Object[]{converter.getSupportedMediaTypes()});
    }

    @Override
    public void autoType(String autoType) {
        this.autoType = autoType;
    }

    private static class AutoTypeAdapterFactory
    implements TypeAdapterFactory {
        private final String autoTypePrefix;

        public AutoTypeAdapterFactory(String autoTypePrefix) {
            this.autoTypePrefix = autoTypePrefix;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (this.autoTypePrefix != null && !rawType.getName().startsWith(this.autoTypePrefix)) {
                throw new JsonParseException("Type not allowed: " + rawType.getName() + ", must start with package prefix: " + this.autoTypePrefix);
            }
            return null;
        }
    }
}

