/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.web;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.web.JsonConverterConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={JSON.class})
public class FastJsonConverterConfigurer
implements JsonConverterConfigurer {
    private static final List<MediaType> DEFAULT_MEDIA_TYPES = List.of(MediaType.APPLICATION_JSON, new MediaType(MediaType.TEXT_PLAIN, StandardCharsets.UTF_8));
    private String autoType;

    @Override
    public String name() {
        return "Fastjson2";
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public void configure(List<HttpMessageConverter<?>> converters) {
        Logger.debug((String)"Configuring FastJson2HttpMessageConverter for Fastjson2", (Object[])new Object[0]);
        converters.add(this.order(), (HttpMessageConverter<?>)new FastJson2HttpMessageConverter(this.autoType));
        Logger.debug((String)"FastJson2HttpMessageConverter configured with media types: {}", (Object[])new Object[]{DEFAULT_MEDIA_TYPES});
    }

    @Override
    public void autoType(String autoType) {
        this.autoType = autoType;
    }

    static class FastJson2HttpMessageConverter
    extends AbstractHttpMessageConverter<Object> {
        private static final JSONWriter.Feature[] WRITER_FEATURES = new JSONWriter.Feature[]{JSONWriter.Feature.FieldBased, JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNulls};
        private static final JSONReader.Feature[] READER_FEATURES = new JSONReader.Feature[]{JSONReader.Feature.FieldBased};
        private static final Filter[] FILTERS = new Filter[]{(object, name, value) -> value == null || "".equals(value) || " ".equals(value) ? null : value};
        private final String[] autoTypes;

        public FastJson2HttpMessageConverter(String autoType) {
            super(StandardCharsets.UTF_8, DEFAULT_MEDIA_TYPES.toArray(new MediaType[0]));
            if (StringKit.isEmpty((CharSequence)autoType)) {
                this.autoTypes = null;
                Logger.info((String)"Fastjson2 autoType is not configured, @type deserialization is disabled", (Object[])new Object[0]);
            } else {
                this.autoTypes = StringKit.splitToArray((CharSequence)autoType, (CharSequence)",");
                for (int i = 0; i < this.autoTypes.length; ++i) {
                    this.autoTypes[i] = this.autoTypes[i].trim();
                    if (!StringKit.isEmpty((CharSequence)this.autoTypes[i])) continue;
                    throw new IllegalArgumentException("autoType contains empty or invalid types");
                }
                Logger.info((String)"Fastjson2 autoType is enabled, whitelist types: {}", (Object[])new Object[]{String.join((CharSequence)", ", this.autoTypes)});
            }
        }

        protected boolean supports(Class<?> clazz) {
            return true;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
            Object object;
            InputStream inputStream = null;
            try {
                inputStream = inputMessage.getBody();
                byte[] bytes = IoKit.readBytes((InputStream)inputStream);
                String jsonString = new String(bytes, StandardCharsets.UTF_8);
                Logger.debug((String)"Deserializing JSON for class {}", (Object[])new Object[]{clazz.getName()});
                if (this.autoTypes != null && !this.isSafeJson(jsonString)) {
                    Logger.error((String)"JSON contains untrusted @type: {}", (Object[])new Object[]{jsonString});
                    throw new HttpMessageNotReadableException("JSON contains untrusted @type", inputMessage);
                }
                Object result = this.autoTypes == null ? JSON.parseObject((String)jsonString, clazz, (JSONReader.Feature[])READER_FEATURES) : JSON.parseObject((String)jsonString, clazz, (Filter)JSONReader.autoTypeFilter((String[])this.autoTypes), (JSONReader.Feature[])READER_FEATURES);
                Logger.debug((String)"Deserialization successful for class {}", (Object[])new Object[]{clazz.getName()});
                object = result;
            }
            catch (IOException e) {
                try {
                    Logger.error((String)"IO error occurred during JSON deserialization, class {}: {}", (Object[])new Object[]{clazz.getName(), e.getMessage(), e});
                    throw new HttpMessageNotReadableException("IO error occurred during JSON deserialization: " + e.getMessage(), (Throwable)e, inputMessage);
                    catch (Exception e2) {
                        Logger.error((String)"JSON deserialization failed, class {}: {}", (Object[])new Object[]{clazz.getName(), e2.getMessage(), e2});
                        throw new HttpMessageNotReadableException("JSON deserialization failed: " + e2.getMessage(), (Throwable)e2, inputMessage);
                    }
                }
                catch (Throwable throwable) {
                    IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{inputStream});
                    throw throwable;
                }
            }
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{inputStream});
            return object;
        }

        protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
            try {
                Logger.debug((String)"Serializing object: {}", (Object[])new Object[]{object != null ? object.getClass().getName() : "null"});
                String jsonString = JSON.toJSONString((Object)object, (Filter[])FILTERS, (JSONWriter.Feature[])WRITER_FEATURES);
                byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                outputMessage.getBody().write(bytes);
                Logger.debug((String)"Serialization successful, JSON length: {}", (Object[])new Object[]{jsonString.length()});
            }
            catch (IOException e) {
                Logger.error((String)"IO error occurred during JSON serialization: {}", (Object[])new Object[]{e.getMessage(), e});
                throw new HttpMessageNotWritableException("IO error occurred during JSON serialization: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                Logger.error((String)"JSON serialization failed: {}", (Object[])new Object[]{e.getMessage(), e});
                throw new HttpMessageNotWritableException("JSON serialization failed: " + e.getMessage(), (Throwable)e);
            }
        }

        private boolean isSafeJson(String jsonString) {
            if (jsonString.contains("@type")) {
                for (String autoType : this.autoTypes) {
                    if (!jsonString.contains(autoType)) continue;
                    Logger.debug((String)"Found trusted @type: {}", (Object[])new Object[]{autoType});
                    return true;
                }
                Logger.warn((String)"Untrusted @type detected in JSON: {}", (Object[])new Object[]{jsonString});
                return false;
            }
            return true;
        }
    }
}

