/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.spring.GeniusBuilder;
import org.springframework.boot.Banner;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessorApplicationListener;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class SpringCloudConfigListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final MapPropertySource HIGH_PRIORITY_CONFIG = new MapPropertySource("priorityConfig", new HashMap());

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (GeniusBuilder.isSpringCloudEnvironmentEnabled((Environment)environment)) {
            if (environment.getPropertySources().contains("bootstrap")) {
                environment.getPropertySources().addLast((PropertySource)HIGH_PRIORITY_CONFIG);
            } else {
                SpringApplication application = event.getSpringApplication();
                StandardEnvironment bootstrapEnvironment = new StandardEnvironment();
                StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(source -> !(source instanceof PropertySource.StubPropertySource)).forEach(source -> bootstrapEnvironment.getPropertySources().addLast(source));
                ArrayList<Class> sources = new ArrayList<Class>();
                for (Object s : application.getAllSources()) {
                    if (s instanceof Class) {
                        sources.add((Class)s);
                        continue;
                    }
                    if (!(s instanceof String)) continue;
                    sources.add(ClassKit.forName((String)((String)s), null));
                }
                SpringApplication bootstrapApplication = new SpringApplicationBuilder(new Class[0]).profiles(environment.getActiveProfiles()).bannerMode(Banner.Mode.OFF).environment((ConfigurableEnvironment)bootstrapEnvironment).sources(sources.toArray(new Class[0])).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE).listeners(new ApplicationListener[0]).initializers(new ApplicationContextInitializer[0]).build(event.getArgs());
                ConfigurableBootstrapContext bootstrapContext = event.getBootstrapContext();
                ApplicationEnvironmentPreparedEvent bootstrapEvent = new ApplicationEnvironmentPreparedEvent(bootstrapContext, bootstrapApplication, event.getArgs(), (ConfigurableEnvironment)bootstrapEnvironment);
                application.getListeners().stream().filter(listener -> listener instanceof EnvironmentPostProcessorApplicationListener).forEach(listener -> ((EnvironmentPostProcessorApplicationListener)listener).onApplicationEvent((ApplicationEvent)bootstrapEvent));
                this.logSetting((ConfigurableEnvironment)bootstrapEnvironment);
                this.requireProperties((ConfigurableEnvironment)bootstrapEnvironment);
            }
        }
    }

    private void logSetting(ConfigurableEnvironment environment) {
        StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(propertySource -> propertySource instanceof EnumerablePropertySource).map(propertySource -> Arrays.asList(((EnumerablePropertySource)propertySource).getPropertyNames())).flatMap(Collection::stream).filter(GeniusBuilder::isLoggingConfig).forEach(key -> ((Map)HIGH_PRIORITY_CONFIG.getSource()).put(key, environment.getProperty(key)));
    }

    private void requireProperties(ConfigurableEnvironment environment) {
        if (StringKit.hasText((String)environment.getProperty("spring.application.name"))) {
            ((Map)HIGH_PRIORITY_CONFIG.getSource()).put("spring.application.name", environment.getProperty("spring.application.name"));
        }
    }
}

