/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.listener;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.miaixz.bus.spring.banner.BannerPrinter;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringBootConfigListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private final AtomicBoolean registered = new AtomicBoolean();
    public SpringApplication application;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        this.application = event.getSpringApplication();
        if (this.registered.compareAndSet(false, true)) {
            this.registerConfigs(event.getEnvironment());
        }
    }

    public int getOrder() {
        return -2147483635;
    }

    public void registerConfigs(ConfigurableEnvironment environment) {
        Properties props = new Properties();
        props.setProperty("bus.version", "8.2.1");
        MutablePropertySources sources = environment.getPropertySources();
        sources.addLast((PropertySource)new PropertiesPropertySource("bus", props));
        new BannerPrinter().printBanner(this.application, environment);
    }
}

