/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.env;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.miaixz.bus.core.xyz.SetKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.GeniusBuilder;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ScenesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ResourceLoader resourceLoader = application.getResourceLoader();
        resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        List propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
        String scenesValue = environment.getProperty("bus.scenes");
        if (!StringKit.hasText((String)scenesValue)) {
            return;
        }
        HashSet scenes = SetKit.of((Object[])new String[]{scenesValue});
        List<SceneConfigDataReference> sceneConfigDataReferences = this.scenesResources(resourceLoader, propertySourceLoaders, scenes);
        Logger.info((String)"Configs for scenes {} enable", (Object[])new Object[]{scenes});
        this.processAndApply(sceneConfigDataReferences, environment);
    }

    public int getOrder() {
        return 2147483547;
    }

    private List<SceneConfigDataReference> scenesResources(ResourceLoader resourceLoader, List<PropertySourceLoader> propertySourceLoaders, Set<String> scenes) {
        ArrayList<SceneConfigDataReference> resources = new ArrayList<SceneConfigDataReference>();
        if (scenes != null && !scenes.isEmpty()) {
            scenes.forEach(scene -> propertySourceLoaders.forEach(psl -> {
                for (String extension : psl.getFileExtensions()) {
                    String location = "classpath:/" + GeniusBuilder.BUS_SCENES_PATH + File.separator + scene + "." + extension;
                    Resource resource = resourceLoader.getResource(location);
                    if (!resource.exists()) continue;
                    resources.add(new SceneConfigDataReference(location, resource, (PropertySourceLoader)psl));
                }
            }));
        }
        return resources;
    }

    private void processAndApply(List<SceneConfigDataReference> sceneConfigDataReferences, ConfigurableEnvironment environment) {
        for (SceneConfigDataReference sceneConfigDataReference : sceneConfigDataReferences) {
            try {
                List propertySources = sceneConfigDataReference.propertySourceLoader.load(sceneConfigDataReference.getName(), sceneConfigDataReference.getResource());
                if (propertySources == null) continue;
                propertySources.forEach(arg_0 -> ((MutablePropertySources)environment.getPropertySources()).addLast(arg_0));
            }
            catch (IOException e) {
                throw new IllegalStateException("IO error on loading scene config data from " + sceneConfigDataReference.name, e);
            }
        }
    }

    private static class SceneConfigDataReference {
        private String name;
        private Resource resource;
        private PropertySourceLoader propertySourceLoader;

        public SceneConfigDataReference(String name, Resource resource, PropertySourceLoader propertySourceLoader) {
            this.name = name;
            this.resource = resource;
            this.propertySourceLoader = propertySourceLoader;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }

        public PropertySourceLoader getPropertySourceLoader() {
            return this.propertySourceLoader;
        }

        public void setPropertySourceLoader(PropertySourceLoader propertySourceLoader) {
            this.propertySourceLoader = propertySourceLoader;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

