/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.env;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.spring.GeniusBuilder;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class LoggingEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static void keepCompatible(Map<String, String> context, boolean keep) {
        if (!keep) {
            return;
        }
        String loggingPath = System.getProperty("logging.path", context.get("logging.path"));
        System.setProperty("logging.path", loggingPath);
        String fileEncoding = System.getProperty("file.encoding", context.get("file.encoding"));
        System.setProperty("file.encoding", fileEncoding);
        String patternConsole = System.getProperty("logging.pattern.console", context.get("logging.pattern.console"));
        if (StringKit.isEmpty((CharSequence)patternConsole)) {
            patternConsole = "%green(%d{yyyy-MM-dd HH:mm:ss.SSSXXX}) [%highlight(%5p)] %magenta(${PID:- }) %yellow(-) %highlight(%-50.50logger{50}) %yellow(%5.5L) %cyan(:) %magenta(%m%n)";
        }
        System.setProperty("logging.pattern.console", patternConsole);
        String patternFile = System.getProperty("logging.pattern.file", context.get("logging.pattern.file"));
        if (StringKit.isEmpty((CharSequence)patternFile)) {
            patternFile = "%d{yyyy-MM-dd HH:mm:ss.SSSXXX} [%5p] ${PID:- } - %-50.50logger{50} %5.5L : %m%n";
        }
        System.setProperty("logging.pattern.file", patternFile);
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, String> context = new HashMap<String, String>();
        this.loadLogConfiguration("logging.path", environment.getProperty("logging.path"), context, Keys.get((String)"user.name") + GeniusBuilder.BUS_LOGGING_PATH);
        this.loadLogConfiguration("file.encoding", environment.getProperty("file.encoding"), context, null);
        this.loadLogConfiguration("logging.pattern.console", environment.getProperty("logging.pattern.console"), context, null);
        this.loadLogConfiguration("logging.pattern.file", environment.getProperty("logging.pattern.file"), context, null);
        LoggingEnvironmentPostProcessor.keepCompatible(context, true);
    }

    public int getOrder() {
        return -2147483637;
    }

    public void loadLogConfiguration(String key, String value, Map<String, String> context, String defaultValue) {
        if (StringKit.hasText((String)value)) {
            context.put(key, value);
        } else if (StringKit.hasText((String)defaultValue)) {
            context.put(key, defaultValue);
        }
    }
}

