/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.boot;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.miaixz.bus.spring.boot.statics.BaseStatics;
import org.miaixz.bus.spring.boot.statics.BeanStatics;
import org.miaixz.bus.spring.boot.statics.BeanStaticsCustomizer;
import org.miaixz.bus.spring.boot.statics.StartupStatics;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.boot.context.metrics.buffering.StartupTimeline;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;

public class StartupReporter {
    public static final Collection<String> SPRING_BEAN_INSTANTIATE_TYPES = Set.of("spring.beans.instantiate", "spring.beans.smart-initialize");
    public static final Collection<String> SPRING_CONTEXT_POST_PROCESSOR_TYPES = Set.of("spring.context.beandef-registry.post-process", "spring.context.bean-factory.post-process");
    public static final Collection<String> SPRING_CONFIG_CLASSES_ENHANCE_TYPES = Set.of("spring.context.config-classes.enhance", "spring.context.beans.post-process");
    public final StartupStatics statics = new StartupStatics();
    public final List<BeanStaticsCustomizer> beanStaticsCustomizers;
    public int bufferSize = 4096;
    public int costThreshold = 50;

    public StartupReporter() {
        this.statics.setApplicationBootTime(ManagementFactory.getRuntimeMXBean().getStartTime());
        this.beanStaticsCustomizers = SpringFactoriesLoader.loadFactories(BeanStaticsCustomizer.class, (ClassLoader)StartupReporter.class.getClassLoader());
    }

    public void bindToStartupReporter(ConfigurableEnvironment environment) {
        try {
            Binder.get((Environment)environment).bind("bus.startup", Bindable.ofInstance((Object)this));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot bind to StartupReporter", ex);
        }
    }

    public void setAppName(String appName) {
        this.statics.setAppName(appName);
    }

    public void applicationBootFinish() {
        this.statics.setApplicationBootElapsedTime(ManagementFactory.getRuntimeMXBean().getUptime());
        this.statics.getStageStats().sort((o1, o2) -> {
            if (o1.getStartTime() == o2.getStartTime()) {
                return 0;
            }
            return o1.getStartTime() > o2.getStartTime() ? 1 : -1;
        });
    }

    public void addCommonStartupStat(BaseStatics stat) {
        this.statics.getStageStats().add(stat);
    }

    public BaseStatics getStageNyName(String stageName) {
        return this.statics.getStageStats().stream().filter(commonStartupStat -> commonStartupStat.getName().equals(stageName)).findFirst().orElse(null);
    }

    public StartupStatics drainStartupStatics() {
        StartupStatics startupReporterStatics = new StartupStatics();
        startupReporterStatics.setAppName(this.statics.getAppName());
        startupReporterStatics.setApplicationBootElapsedTime(this.statics.getApplicationBootElapsedTime());
        startupReporterStatics.setApplicationBootTime(this.statics.getApplicationBootTime());
        ArrayList<BaseStatics> stats = new ArrayList<BaseStatics>();
        Iterator<BaseStatics> iterator = this.statics.getStageStats().iterator();
        while (iterator.hasNext()) {
            stats.add(iterator.next());
            iterator.remove();
        }
        startupReporterStatics.setStageStats(stats);
        return startupReporterStatics;
    }

    public List<BeanStatics> generateBeanStats(ConfigurableApplicationContext context) {
        ArrayList<BeanStatics> rootBeanList = new ArrayList<BeanStatics>();
        ApplicationStartup applicationStartup = context.getApplicationStartup();
        if (applicationStartup instanceof BufferingApplicationStartup) {
            BufferingApplicationStartup bufferingApplicationStartup = (BufferingApplicationStartup)applicationStartup;
            HashMap beanStatIdMap = new HashMap();
            StartupTimeline startupTimeline = bufferingApplicationStartup.drainBufferedTimeline();
            List timelineEvents = startupTimeline.getEvents();
            timelineEvents.forEach(timelineEvent -> {
                BeanStatics bean = this.eventToBeanStat((StartupTimeline.TimelineEvent)timelineEvent);
                rootBeanList.add(bean);
                beanStatIdMap.put(timelineEvent.getStartupStep().getId(), bean);
            });
            timelineEvents.forEach(timelineEvent -> {
                BeanStatics parentBean = (BeanStatics)beanStatIdMap.get(timelineEvent.getStartupStep().getParentId());
                BeanStatics bean = (BeanStatics)beanStatIdMap.get(timelineEvent.getStartupStep().getId());
                if (parentBean != null) {
                    parentBean.setRealRefreshElapsedTime(parentBean.getRealRefreshElapsedTime() - bean.getCost());
                    rootBeanList.remove(bean);
                    if (this.filterBeanInitializeByCost(bean)) {
                        parentBean.addChild(bean);
                        this.customBeanStat(context, bean);
                    }
                } else if (!this.filterBeanInitializeByCost(bean)) {
                    rootBeanList.remove(bean);
                } else {
                    this.customBeanStat(context, bean);
                }
            });
        }
        return rootBeanList;
    }

    private boolean filterBeanInitializeByCost(BeanStatics bean) {
        String name = bean.getType();
        if (SPRING_BEAN_INSTANTIATE_TYPES.contains(name) || SPRING_CONTEXT_POST_PROCESSOR_TYPES.contains(name) || SPRING_CONFIG_CLASSES_ENHANCE_TYPES.contains(name)) {
            return bean.getCost() >= (long)this.costThreshold;
        }
        return true;
    }

    private BeanStatics eventToBeanStat(StartupTimeline.TimelineEvent timelineEvent) {
        BeanStatics bean = new BeanStatics();
        bean.setStartTime(timelineEvent.getStartTime().toEpochMilli());
        bean.setEndTime(timelineEvent.getEndTime().toEpochMilli());
        bean.setCost(timelineEvent.getDuration().toMillis());
        bean.setRealRefreshElapsedTime(bean.getCost());
        String name = timelineEvent.getStartupStep().getName();
        bean.setType(name);
        if (SPRING_BEAN_INSTANTIATE_TYPES.contains(name)) {
            StartupStep.Tags tags = timelineEvent.getStartupStep().getTags();
            String beanName = this.getValueFromTags(tags, "beanName");
            bean.setName(beanName);
        } else if (SPRING_CONTEXT_POST_PROCESSOR_TYPES.contains(name)) {
            StartupStep.Tags tags = timelineEvent.getStartupStep().getTags();
            String beanName = this.getValueFromTags(tags, "postProcessor");
            bean.setName(beanName);
        } else {
            bean.setName(name);
        }
        timelineEvent.getStartupStep().getTags().forEach(tag -> bean.putAttribute(tag.getKey(), tag.getValue()));
        return bean;
    }

    private String getValueFromTags(StartupStep.Tags tags, String key) {
        for (StartupStep.Tag tag : tags) {
            if (!Objects.equals(key, tag.getKey())) continue;
            return tag.getValue();
        }
        return null;
    }

    private BeanStatics customBeanStat(ConfigurableApplicationContext context, BeanStatics beanStat) {
        if (!context.isActive()) {
            return beanStat;
        }
        String type = beanStat.getType();
        if (SPRING_BEAN_INSTANTIATE_TYPES.contains(type)) {
            String beanName = beanStat.getName();
            Object bean = context.getBean(beanName);
            beanStat.putAttribute("classType", AopProxyUtils.ultimateTargetClass((Object)bean).getName());
            BeanStatics result = beanStat;
            for (BeanStaticsCustomizer customizer : this.beanStaticsCustomizers) {
                BeanStatics current = customizer.customize(beanName, bean, result);
                if (current == null) {
                    return result;
                }
                result = current;
            }
            return result;
        }
        return beanStat;
    }
}

