/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.boot;

import org.miaixz.bus.spring.boot.StartupReporter;
import org.miaixz.bus.spring.boot.statics.ChildrenStatics;
import org.miaixz.bus.spring.boot.statics.ModuleStatics;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;

public class SpringSmartLifecycle
implements SmartLifecycle,
ApplicationContextAware {
    public static final String ROOT_MODULE_NAME = "ROOT_APPLICATION_CONTEXT";
    private final StartupReporter startupReporter;
    private ConfigurableApplicationContext applicationContext;

    public SpringSmartLifecycle(StartupReporter startupReporter) {
        this.startupReporter = startupReporter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void start() {
        ChildrenStatics<ModuleStatics> stat = new ChildrenStatics<ModuleStatics>();
        stat.setName("ApplicationContextRefreshStage");
        stat.setEndTime(System.currentTimeMillis());
        ModuleStatics rootModuleStat = new ModuleStatics();
        rootModuleStat.setName(ROOT_MODULE_NAME);
        rootModuleStat.setEndTime(stat.getEndTime());
        rootModuleStat.setThreadName(Thread.currentThread().getName());
        rootModuleStat.setChildren(this.startupReporter.generateBeanStats(this.applicationContext));
        stat.addChild(rootModuleStat);
        this.startupReporter.addCommonStartupStat(stat);
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }
}

