/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.boot;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.boot.SpringApplication;
import org.miaixz.bus.spring.boot.SpringSmartLifecycle;
import org.miaixz.bus.spring.boot.StartupReporter;
import org.miaixz.bus.spring.boot.StartupReporterProcessor;
import org.miaixz.bus.spring.boot.statics.BaseStatics;
import org.miaixz.bus.spring.boot.statics.ChildrenStatics;
import org.miaixz.bus.spring.boot.statics.ModuleStatics;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.metrics.ApplicationStartup;

public class SpringApplicationRunListener
implements org.springframework.boot.SpringApplicationRunListener,
ApplicationListener<ApplicationStartedEvent>,
Ordered {
    private final org.springframework.boot.SpringApplication application;
    private final StartupReporter startupReporter;
    private BaseStatics jvmStartingStage;
    private BaseStatics environmentPrepareStage;
    private ChildrenStatics<BaseStatics> applicationContextPrepareStage;
    private BaseStatics applicationContextLoadStage;

    public SpringApplicationRunListener(org.springframework.boot.SpringApplication springApplication) {
        this.application = springApplication;
        this.startupReporter = new StartupReporter();
        Logger.debug((String)"Initialized SpringApplicationRunListener for application: {}", (Object[])new Object[]{springApplication.getMainApplicationClass()});
    }

    public void starting(ConfigurableBootstrapContext bootstrapContext) {
        this.jvmStartingStage = new BaseStatics();
        this.jvmStartingStage.setName("JvmStartingStage");
        this.jvmStartingStage.setStartTime(ManagementFactory.getRuntimeMXBean().getStartTime());
        this.jvmStartingStage.setEndTime(System.currentTimeMillis());
        Logger.debug((String)"JVM starting stage completed in {} ms", (Object[])new Object[]{this.jvmStartingStage.getCost()});
    }

    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment) {
        this.environmentPrepareStage = new BaseStatics();
        this.environmentPrepareStage.setName("EnvironmentPrepareStage");
        this.environmentPrepareStage.setStartTime(this.jvmStartingStage.getEndTime());
        this.environmentPrepareStage.setEndTime(System.currentTimeMillis());
        this.startupReporter.setAppName(environment.getProperty("spring.application.name"));
        this.startupReporter.bindToStartupReporter(environment);
        bootstrapContext.register(StartupReporter.class, key -> this.startupReporter);
        try {
            Class.forName("org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup");
            this.application.setApplicationStartup((ApplicationStartup)new BufferingApplicationStartup(this.startupReporter.bufferSize));
        }
        catch (ClassNotFoundException e) {
            Logger.debug((String)"BufferingApplicationStartup not available, skipping startup metrics", (Object[])new Object[0]);
        }
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
        this.applicationContextPrepareStage = new ChildrenStatics();
        this.applicationContextPrepareStage.setName("ApplicationContextPrepareStage");
        this.applicationContextPrepareStage.setStartTime(this.environmentPrepareStage.getEndTime());
        this.applicationContextPrepareStage.setEndTime(System.currentTimeMillis());
        org.springframework.boot.SpringApplication springApplication = this.application;
        if (springApplication instanceof SpringApplication) {
            SpringApplication springApplication2 = (SpringApplication)springApplication;
            List<BaseStatics> statisticsList = springApplication2.getInitializerStartupStatList();
            this.applicationContextPrepareStage.setChildren(new ArrayList<BaseStatics>(statisticsList));
            statisticsList.clear();
        }
        Logger.debug((String)"Application context preparation stage completed in {} ms", (Object[])new Object[]{this.applicationContextPrepareStage.getCost()});
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
        this.applicationContextLoadStage = new BaseStatics();
        this.applicationContextLoadStage.setName("ApplicationContextLoadStage");
        this.applicationContextLoadStage.setStartTime(this.applicationContextPrepareStage.getEndTime());
        this.applicationContextLoadStage.setEndTime(System.currentTimeMillis());
        context.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new StartupReporterProcessor(this.startupReporter));
        context.getBeanFactory().registerSingleton("STARTUP_REPORTER_BEAN", (Object)this.startupReporter);
        SpringSmartLifecycle springSmartLifecycle = new SpringSmartLifecycle(this.startupReporter);
        springSmartLifecycle.setApplicationContext((ApplicationContext)context);
        context.getBeanFactory().registerSingleton("STARTUP_SMART_LIFECYCLE", (Object)springSmartLifecycle);
        Logger.debug((String)"Application context loading stage completed in {} ms", (Object[])new Object[]{this.applicationContextLoadStage.getCost()});
    }

    public void started(ConfigurableApplicationContext context, Duration timeTaken) {
        ChildrenStatics applicationRefreshStage = (ChildrenStatics)this.startupReporter.getStageNyName("ApplicationContextRefreshStage");
        applicationRefreshStage.setStartTime(this.applicationContextLoadStage.getEndTime());
        applicationRefreshStage.setEndTime(System.currentTimeMillis());
        applicationRefreshStage.setCost(applicationRefreshStage.getEndTime() - applicationRefreshStage.getStartTime());
        ModuleStatics rootModule = (ModuleStatics)applicationRefreshStage.getChildren().get(0);
        rootModule.setStartTime(applicationRefreshStage.getStartTime());
        rootModule.setCost(rootModule.getEndTime() - rootModule.getStartTime());
        this.startupReporter.addCommonStartupStat(this.jvmStartingStage);
        this.startupReporter.addCommonStartupStat(this.environmentPrepareStage);
        this.startupReporter.addCommonStartupStat(this.applicationContextPrepareStage);
        this.startupReporter.addCommonStartupStat(this.applicationContextLoadStage);
        this.startupReporter.applicationBootFinish();
        Logger.info((String)this.getStartedMessage(context, timeTaken), (Object[])new Object[0]);
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        Logger.debug((String)"Received ApplicationStartedEvent for application: {}", (Object[])new Object[]{this.application.getMainApplicationClass()});
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    private String getStartedMessage(ConfigurableApplicationContext context, Duration timeTakenToStartup) {
        StringBuilder message = new StringBuilder();
        message.append("Started");
        ConfigurableEnvironment environment = context.getEnvironment();
        String appName = (String)StringKit.defaultIfEmpty((CharSequence)environment.getProperty("spring.application.name"), (CharSequence)"unknown");
        message.append(" - App Name: ").append(appName);
        String configName = (String)StringKit.defaultIfEmpty((CharSequence)environment.getProperty("spring.config.name"), (CharSequence)"application");
        message.append(" - Config Name: ").append(configName);
        CharSequence[] activeProfiles = environment.getActiveProfiles();
        message.append(" - Active Profiles: ").append(activeProfiles.length > 0 ? String.join((CharSequence)", ", activeProfiles) : "none");
        String logging = environment.getProperty("logging.level");
        if (!StringKit.hasText((String)logging)) {
            LoggingSystem loggingSystem = (LoggingSystem)context.getBean(LoggingSystem.class);
            for (LoggerConfiguration config : loggingSystem.getLoggerConfigurations()) {
                if (!"org.miaixz".equalsIgnoreCase(config.getName())) continue;
                logging = config.getEffectiveLevel().name();
                break;
            }
        }
        if (StringKit.hasText((String)logging)) {
            message.append(" with [").append(logging).append("]");
        }
        message.append(" in ");
        message.append((double)timeTakenToStartup.toMillis() / 1000.0);
        message.append(" seconds");
        return message.toString();
    }
}

