/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.boot;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.boot.statics.BaseStatics;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.io.ResourceLoader;

public class SpringApplication
extends org.springframework.boot.SpringApplication {
    private final List<BaseStatics> initializerStartupStatList = new ArrayList<BaseStatics>();

    public SpringApplication(Class<?> ... primarySources) {
        super((Class[])primarySources);
    }

    public SpringApplication(ResourceLoader resourceLoader, Class<?> ... primarySources) {
        super(resourceLoader, (Class[])primarySources);
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        return SpringApplication.run(new Class[]{primarySource}, args);
    }

    public static ConfigurableApplicationContext run(Class<?>[] primarySources, String[] args) {
        return new SpringApplication(primarySources).run(args);
    }

    public ConfigurableApplicationContext run(String ... args) {
        return super.run(args);
    }

    protected void applyInitializers(ConfigurableApplicationContext context) {
        for (ApplicationContextInitializer initializer : this.getInitializers()) {
            try {
                Class requiredType = GenericTypeResolver.resolveTypeArgument((Class)initializer.getClass(), ApplicationContextInitializer.class);
                Assert.isInstanceOf((Class)requiredType, (Object)context, (String)("Unable to call initializer: " + initializer.getClass().getName()), (Object[])new Object[0]);
                BaseStatics stat = new BaseStatics();
                stat.setName(initializer.getClass().getName());
                stat.setStartTime(System.currentTimeMillis());
                initializer.initialize(context);
                stat.setEndTime(System.currentTimeMillis());
                this.initializerStartupStatList.add(stat);
                Logger.debug((String)"Initialized {} in {} ms", (Object[])new Object[]{stat.getName(), stat.getCost()});
            }
            catch (Exception e) {
                Logger.warn((String)"Failed to initialize {}: {}", (Object[])new Object[]{initializer.getClass().getName(), e.getMessage()});
            }
        }
    }

    public List<BaseStatics> getInitializerStartupStatList() {
        return this.initializerStartupStatList;
    }
}

