/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.banner;

import java.io.PrintStream;
import org.miaixz.bus.core.Version;
import org.miaixz.bus.spring.GeniusBuilder;
import org.miaixz.bus.spring.banner.AbstractBanner;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.core.env.Environment;

public class TextBanner
extends AbstractBanner
implements Banner {
    public TextBanner() {
        super(null, null, null);
    }

    public TextBanner(Class<?> resourceClass, String resourceLocation, String defaultBanner) {
        super(resourceClass, resourceLocation, defaultBanner);
    }

    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream printStream) {
        printStream.println();
        printStream.println(this.printBanner(null));
        printStream.println();
    }

    @Override
    protected String printBanner(String bannerText) {
        StringBuilder builder = new StringBuilder();
        for (String line : GeniusBuilder.BUS_BANNER) {
            builder.append(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_GREEN, line}) + "\n");
        }
        String springVersion = " :: Spring Boot :: " + String.format("(v%s)", SpringBootVersion.getVersion());
        String busVersion = " :: Bus Boot :: " + String.format("(v%s)", Version.all());
        StringBuilder padding = new StringBuilder();
        while (padding.length() < 70 - (springVersion.length() + busVersion.length())) {
            padding.append(" ");
        }
        builder.append(AnsiOutput.toString((Object[])new Object[]{AnsiColor.BRIGHT_MAGENTA, springVersion, padding.toString(), AnsiColor.BRIGHT_MAGENTA, busVersion}));
        return builder.toString();
    }
}

