/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.banner;

import java.io.BufferedReader;
import java.util.Properties;
import java.util.stream.Collectors;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.spring.SpringBuilder;
import org.miaixz.bus.spring.banner.TextBanner;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;

public class BannerPrinter {
    public void printBanner(SpringApplication app, ConfigurableEnvironment env) {
        Banner banner = (Banner)FieldKit.getFieldValue((Object)app, (String)"banner");
        if (banner != null) {
            return;
        }
        String location = env.getProperty("spring.banner.location", "banner.txt");
        if (FileKit.exists((String)location)) {
            BufferedReader reader = ResourceKit.getReader((String)location);
            String text = reader.lines().map(line -> SpringBuilder.replacePlaceholders(line, env)).collect(Collectors.joining("\n"));
            banner = (e, s, p) -> p.print(text);
            app.setBanner(banner);
            return;
        }
        banner = new TextBanner();
        app.setBanner(banner);
    }

    private String replacePlaceholders(String text, ConfigurableEnvironment env) {
        Properties props = new Properties();
        env.getPropertySources().forEach(source -> {
            if (source instanceof EnumerablePropertySource) {
                EnumerablePropertySource eps = (EnumerablePropertySource)source;
                for (String name : eps.getPropertyNames()) {
                    props.put(name, String.valueOf(eps.getProperty(name)));
                }
            }
        });
        String result = text;
        for (String key : props.stringPropertyNames()) {
            result = result.replace("${" + key + "}", props.getProperty(key));
        }
        return result;
    }
}

