/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.autoproxy;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.PatternKit;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;

public class ExcludeBeanNameAutoProxy
extends BeanNameAutoProxyCreator {
    private List<String> excludeBeanNames;

    public void setExcludeBeanNames(String ... beanNames) {
        Assert.notEmpty((Object[])beanNames, (String)"'excludeBeanNames' must not be empty", (Object[])new Object[0]);
        this.excludeBeanNames = new ArrayList<String>(beanNames.length);
        for (String mappedName : beanNames) {
            this.excludeBeanNames.add(mappedName.strip());
        }
    }

    protected boolean isMatch(String beanName, String mappedName) {
        return super.isMatch(beanName, mappedName) && !this.isExcluded(beanName);
    }

    private boolean isExcluded(String beanName) {
        if (this.excludeBeanNames != null) {
            for (String mappedName : this.excludeBeanNames) {
                if (!PatternKit.isMatch((String)mappedName, (CharSequence)beanName)) continue;
                return true;
            }
        }
        return false;
    }
}

