/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.spring.annotation.AnnotationWrapper;
import org.miaixz.bus.spring.annotation.PlaceHolderBinder;
import org.miaixz.bus.spring.annotation.WrapperAnnotation;
import org.springframework.core.env.Environment;

public class PlaceHolderHandler
implements InvocationHandler {
    private final Annotation delegate;
    private final PlaceHolderBinder binder;
    private final Environment environment;

    public PlaceHolderHandler(Annotation delegate, PlaceHolderBinder binder, Environment environment) {
        this.delegate = delegate;
        this.binder = binder;
        this.environment = environment;
    }

    public static boolean isObjectMethod(Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || MethodKit.isEqualsMethod((Method)method) || MethodKit.isHashCodeMethod((Method)method) || MethodKit.isToStringMethod((Method)method));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = method.invoke((Object)this.delegate, args);
        if (ret != null && !MethodKit.isObjectMethod((Method)method) && MethodKit.isAttributeMethod((Method)method)) {
            return this.resolvePlaceHolder(ret);
        }
        return ret;
    }

    public Object resolvePlaceHolder(Object origin) {
        if (origin.getClass().isArray()) {
            int length = Array.getLength(origin);
            Object ret = Array.newInstance(origin.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(ret, i, this.resolvePlaceHolder(Array.get(origin, i)));
            }
            return ret;
        }
        return this.doResolvePlaceHolder(origin);
    }

    private Object doResolvePlaceHolder(Object origin) {
        if (origin instanceof String) {
            return this.binder.bind(this.environment, (String)origin);
        }
        if (origin instanceof Annotation && !(origin instanceof WrapperAnnotation)) {
            return AnnotationWrapper.of((Annotation)origin).withBinder(this.binder).withEnvironment(this.environment).wrap((Annotation)origin);
        }
        return origin;
    }
}

