/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.SpringHolder;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.stereotype.Component;

@Component
public class SpringBuilder
implements ApplicationContextAware {
    private static ConfigurableApplicationContext context;

    public static ConfigurableApplicationContext getContext() {
        return context;
    }

    public static void setContext(ConfigurableApplicationContext context) {
        Assert.notNull((Object)context, (String)"Spring context not found.", (Object[])new Object[0]);
        SpringBuilder.context = context;
        SpringHolder.alive = true;
    }

    public static ListableBeanFactory getBeanFactory() {
        return context != null ? context.getBeanFactory() : null;
    }

    public static <T> T getBean(String name) {
        return (T)SpringBuilder.getBeanFactory().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz, Object ... args) {
        return (T)(ArrayKit.isEmpty((Object[])args) ? SpringBuilder.getBeanFactory().getBean(clazz) : SpringBuilder.getBeanFactory().getBean(clazz, args));
    }

    public static <T> T getBean(String name, Object ... args) {
        return (T)(ArrayKit.isEmpty((Object[])args) ? SpringBuilder.getBeanFactory().getBean(name) : SpringBuilder.getBeanFactory().getBean(name, args));
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringBuilder.getBeanFactory().getBean(name, clazz);
    }

    public static <T> T getBean(TypeReference<T> reference) {
        ParameterizedType type = (ParameterizedType)reference.getType();
        Class rawType = (Class)type.getRawType();
        Class[] genericTypes = (Class[])Arrays.stream(type.getActualTypeArguments()).map(t -> (Class)t).toArray(Class[]::new);
        String[] beanNames = SpringBuilder.getBeanFactory().getBeanNamesForType(ResolvableType.forClassWithGenerics((Class)rawType, (Class[])genericTypes));
        return SpringBuilder.getBean(beanNames[0], rawType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return SpringBuilder.getBeanFactory().getBeansOfType(type);
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        return SpringBuilder.getBeanFactory().getBeanNamesForType(type);
    }

    public static String getProperty(String key) {
        return context != null ? context.getEnvironment().getProperty(key) : null;
    }

    public static String[] getActiveProfiles() {
        return context != null ? context.getEnvironment().getActiveProfiles() : null;
    }

    public static String getActiveProfile() {
        Object[] profiles = SpringBuilder.getActiveProfiles();
        return ArrayKit.isNotEmpty((Object[])profiles) ? profiles[0] : null;
    }

    public static void registerBeanDefinition(Class<?> clazz) {
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringBuilder.getBeanFactory();
        factory.registerBeanDefinition(StringKit.lowerFirst((CharSequence)clazz.getSimpleName()), (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(clazz).getBeanDefinition());
    }

    public static void registerSingleton(Class<?> clazz) {
        try {
            SpringBuilder.registerSingleton(clazz, clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Logger.error((String)"Failed to register singleton for class: {}", (Object[])new Object[]{clazz.getName(), e});
        }
    }

    public static void registerSingleton(Class<?> clazz, Object bean) {
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)SpringBuilder.getBeanFactory();
        factory.autowireBean(bean);
        factory.registerSingleton(StringKit.lowerFirst((CharSequence)clazz.getSimpleName()), bean);
    }

    public static void unRegisterSingleton(String beanName) {
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)SpringBuilder.getBeanFactory();
        if (!(factory instanceof DefaultSingletonBeanRegistry)) {
            throw new InternalException("Cannot unregister bean: Factory is not DefaultSingletonBeanRegistry.");
        }
        DefaultSingletonBeanRegistry registry = (DefaultSingletonBeanRegistry)factory;
        registry.destroySingleton(beanName);
    }

    public static void publishEvent(Object event) {
        if (context != null) {
            context.publishEvent(event);
        }
    }

    public static void refreshContext() {
        if (SpringHolder.alive) {
            context.refresh();
        }
    }

    public static void removeContext() {
        if (SpringHolder.alive) {
            context.close();
            context = null;
            SpringHolder.alive = false;
        }
    }

    public static String getApplicationName() {
        return SpringBuilder.getProperty("spring.application.name");
    }

    public static boolean isDemoMode() {
        return SpringBuilder.isDevMode() || SpringBuilder.isTestMode();
    }

    public static boolean isDevMode() {
        return "dev".equalsIgnoreCase(SpringBuilder.getActiveProfile());
    }

    public static boolean isTestMode() {
        return "test".equalsIgnoreCase(SpringBuilder.getActiveProfile());
    }

    public static String replacePlaceholders(String text, ConfigurableEnvironment env) {
        if (context != null) {
            env = context.getEnvironment();
        }
        Properties props = new Properties();
        env.getPropertySources().forEach(source -> {
            if (source instanceof EnumerablePropertySource) {
                EnumerablePropertySource eps = (EnumerablePropertySource)source;
                for (String name : eps.getPropertyNames()) {
                    props.put(name, String.valueOf(eps.getProperty(name)));
                }
            }
        });
        String result = text;
        for (String key : props.stringPropertyNames()) {
            result = result.replace("${" + key + "}", props.getProperty(key));
        }
        return result;
    }

    public static Class<?> resolveBeanClassType(BeanDefinition beanDefinition) {
        Class clazz;
        block13: {
            if (beanDefinition == null) {
                throw new IllegalArgumentException("BeanDefinition cannot be null");
            }
            clazz = null;
            String className = null;
            if (beanDefinition instanceof AnnotatedBeanDefinition) {
                AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
                if (SpringBuilder.isFromConfigurationSource(beanDefinition)) {
                    MethodMetadata methodMetadata = annotatedBeanDefinition.getFactoryMethodMetadata();
                    className = methodMetadata != null ? methodMetadata.getReturnTypeName() : null;
                } else {
                    AnnotationMetadata annotationMetadata = annotatedBeanDefinition.getMetadata();
                    String string = className = annotationMetadata != null ? annotationMetadata.getClassName() : null;
                }
            }
            if (StringKit.hasText(className)) {
                try {
                    clazz = ClassKit.forName(className, null);
                }
                catch (Throwable e) {
                    Logger.debug((String)"Failed to load class: {}", (Object[])new Object[]{className, e});
                }
            }
            if (clazz == null && beanDefinition instanceof AbstractBeanDefinition) {
                AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)beanDefinition;
                try {
                    clazz = abstractBeanDefinition.getBeanClass();
                }
                catch (IllegalStateException e) {
                    Logger.debug((String)"Failed to get bean class from AbstractBeanDefinition", (Object[])new Object[]{e});
                    className = beanDefinition.getBeanClassName();
                    if (!StringKit.hasText((String)className)) break block13;
                    try {
                        clazz = ClassKit.forName((String)className, null);
                    }
                    catch (Throwable ex) {
                        Logger.debug((String)"Failed to load class from bean class name: {}", (Object[])new Object[]{className, ex});
                    }
                }
            }
        }
        if (clazz == null && beanDefinition instanceof RootBeanDefinition) {
            RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
            clazz = rootBeanDefinition.getTargetType();
        }
        return clazz;
    }

    public static boolean isFromConfigurationSource(BeanDefinition beanDefinition) {
        if (beanDefinition == null) {
            throw new IllegalArgumentException("BeanDefinition cannot be null");
        }
        return beanDefinition.getClass().getCanonicalName().startsWith("org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader");
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        context = (ConfigurableApplicationContext)applicationContext;
    }
}

