/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.Provider;
import org.miaixz.bus.spring.SpringBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Component;

@Component
public class ProviderManager {
    public static final Map<Class<Provider<?>>, Collection<Provider<?>>> CACHED_PROVIDERS = new ConcurrentHashMap();
    public static ConfigurableApplicationContext context;

    public static <T extends Provider<S>, S> T load(Class<T> providerClass, S support) {
        Collection<Provider> providers = ProviderManager.loadProvider(providerClass);
        for (Provider provider : providers) {
            if (!Objects.equals(provider.type(), support)) continue;
            return (T)provider;
        }
        return null;
    }

    public static <T extends Provider<?>> Collection<T> all(Class<T> providerClass) {
        return ProviderManager.loadProvider(providerClass);
    }

    private static <T extends Provider<?>> Collection<T> loadProvider(Class<T> providerClass) {
        return CACHED_PROVIDERS.computeIfAbsent(providerClass, key -> {
            if (context == null) {
                context = SpringBuilder.getContext();
            }
            Map beansOfType = context.getBeansOfType(providerClass);
            Collection values = beansOfType.values();
            ArrayList ts = new ArrayList(values);
            AnnotationAwareOrderComparator.sort(ts);
            return ts;
        });
    }
}

