/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring;

import java.io.File;
import org.miaixz.bus.core.xyz.ClassKit;
import org.springframework.core.env.Environment;

public class GeniusBuilder {
    public static final String[] BUS_BANNER = new String[]{" \u2588\u2588\u2588\u2557   \u2588\u2588\u2588\u2557\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557\u2588\u2588\u2557  \u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557    \u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2588\u2588\u2588\u2588\u2557  ", " \u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551\u255a\u2588\u2588\u2557\u2588\u2588\u2554\u255d\u255a\u2550\u2550\u2588\u2588\u2588\u2554\u255d   \u2588\u2588\u2554\u2550\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d  ", " \u2588\u2588\u2554\u2588\u2588\u2588\u2588\u2554\u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551\u2588\u2588\u2551 \u255a\u2588\u2588\u2588\u2554\u255d   \u2588\u2588\u2588\u2554\u255d    \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551  \u2588\u2588\u2588\u2557 ", " \u2588\u2588\u2551\u255a\u2588\u2588\u2554\u255d\u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2551\u2588\u2588\u2551 \u2588\u2588\u2554\u2588\u2588\u2557  \u2588\u2588\u2588\u2554\u255d     \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551   \u2588\u2588\u2551 ", " \u2588\u2588\u2551 \u255a\u2550\u255d \u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2551  \u2588\u2588\u2551\u2588\u2588\u2551\u2588\u2588\u2554\u255d \u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551  \u2588\u2588\u2551\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d ", " \u255a\u2550\u255d     \u255a\u2550\u255d\u255a\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u255d  \u255a\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u255d  "};
    public static final String BUS_BOOT_BANNER = " :: Bus Boot :: ";
    public static final String SPRING_BOOT_BANNER = " :: Spring Boot :: ";
    public static final String BUS_MODULE_FILE = "bus-module.properties";
    public static final String SPRING_CONTEXT_PATH = "META-INF/spring";
    public static final String DEFAULT_PROFILE_VALUE = "default";
    public static final String SPRING_PARENT = "Spring-Parent";
    public static final String MODULE_NAME = "Module-Name";
    public static final String REQUIRE_MODULE = "Require-Module";
    public static final String MODULE_PROFILE = "Module-Profile";
    public static final String BUS_PROPERTY_SOURCE = "configurationProperties";
    public static final String BUS_HIGH_PRIORITY = "priorityConfig";
    public static final String BUS_SCENES = "bus.scenes";
    public static final String BUS_SCENES_PATH = "bus" + File.separator + "scenes";
    public static final String BUS_LOGGING_PATH = File.separator + "logs";
    public static final String LOGGING_PATH = "logging.path";
    public static final String LOGGING_PATH_PREFIX = "logging.path.";
    public static final String LOGGING_LEVEL = "logging.level";
    public static final String LOGGING_LEVEL_PREFIX = "logging.level.";
    public static final String LOGGING_PATTERN_CONSOLE = "logging.pattern.console";
    public static final String LOGGING_PATTERN_FILE = "logging.pattern.file";
    public static final String SPRING_BANNER_TXT = "banner.txt";
    public static final String SPRING_BANNER_LOCATION = "spring.banner.location";
    public static final String BUS_SWITCH_LISTENER_PREFIX_ = "bus.switch.listener.";
    public static final String BANNER = "bus.banner";
    public static final String CACHE = "bus.cache";
    public static final String BRIDGE = "bus.bridge";
    public static final String CORS = "bus.cors";
    public static final String DRUID = "bus.druid";
    public static final String DUBBO = "bus.dubbo";
    public static final String ELASTIC = "bus.elastic";
    public static final String GOALIE = "bus.goalie";
    public static final String HEALTH = "bus.health";
    public static final String I18N = "bus.i18n";
    public static final String IMAGE = "bus.image";
    public static final String LIMITER = "bus.limiter";
    public static final String MONGO = "bus.mongo";
    public static final String MYBATIS = "bus.mybatis";
    public static final String NOTIFY = "bus.notify";
    public static final String AUTH = "bus.auth";
    public static final String OFFICE = "bus.office";
    public static final String PAY = "bus.pay";
    public static final String SENSITIVE = "bus.sensitive";
    public static final String SOCKET = "bus.socket";
    public static final String STORAGE = "bus.storage";
    public static final String WRAPPER = "bus.wrapper";
    public static final String ZOOKEEPER = "bus.zookeeper";
    public static final String WORK = "bus.work";
    public static final String APP_NAME = "spring.application.name";
    public static final String DATASOURCE = "spring.datasource";
    public static final String CLOUD_BOOTSTRAP = "bootstrap";
    public static final String CLOUD_BOOTSTRAP_CONFIGURATION_CLASS = "org.springframework.cloud.bootstrap.BootstrapConfiguration";
    public static final String JVM_STARTING_STAGE = "JvmStartingStage";
    public static final String ENVIRONMENT_PREPARE_STAGE = "EnvironmentPrepareStage";
    public static final String APPLICATION_CONTEXT_PREPARE_STAGE = "ApplicationContextPrepareStage";
    public static final String APPLICATION_CONTEXT_LOAD_STAGE = "ApplicationContextLoadStage";
    public static final String APPLICATION_CONTEXT_REFRESH_STAGE = "ApplicationContextRefreshStage";
    public static final String SPRING_BEANS_INSTANTIATE = "spring.beans.instantiate";
    public static final String SPRING_BEANS_SMART_INSTANTIATE = "spring.beans.smart-initialize";
    public static final String SPRING_CONTEXT_BEANDEF_REGISTRY_POST_PROCESSOR = "spring.context.beandef-registry.post-process";
    public static final String SPRING_CONTEXT_BEAN_FACTORY_POST_PROCESSOR = "spring.context.bean-factory.post-process";
    public static final String SPRING_BEAN_POST_PROCESSOR = "spring.context.beans.post-process";
    public static final String SPRING_CONFIG_CLASSES_ENHANCE = "spring.context.config-classes.enhance";
    private static boolean LOCAL_ENV = false;
    private static boolean TEST_ENV = false;

    public static boolean isSpringCloudEnvironmentEnabled(Environment environment) {
        return ClassKit.isPresent((String)CLOUD_BOOTSTRAP_CONFIGURATION_CLASS, null) && GeniusBuilder.bootstrapEnabled(environment);
    }

    public static boolean bootstrapEnabled(Environment environment) {
        return (Boolean)environment.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)false) != false || ClassKit.isPresent((String)"org.springframework.cloud.bootstrap.marker.Marker", null);
    }

    public static boolean isSpringCloud() {
        return ClassKit.isPresent((String)CLOUD_BOOTSTRAP_CONFIGURATION_CLASS, null);
    }

    public static boolean isSpringTestEnv() {
        return TEST_ENV;
    }

    public static boolean isLocalEnv() {
        return LOCAL_ENV;
    }

    private static void initSpringTestEnv() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"loadContext".equals(stackTraceElement.getMethodName()) || !"org.springframework.boot.test.context.SpringBootContextLoader".equals(stackTraceElement.getClassName())) continue;
            TEST_ENV = true;
            break;
        }
    }

    public static boolean isLoggingConfig(String key) {
        return GeniusBuilder.isLoggingPrefix(key) || LOGGING_PATH.equals(key) || "file.encoding".equals(key);
    }

    public static boolean isLoggingPrefix(String key) {
        return key.startsWith(LOGGING_LEVEL_PREFIX) || key.startsWith(LOGGING_PATH_PREFIX);
    }

    public static boolean isLoggingPattern(String key) {
        return LOGGING_PATTERN_CONSOLE.equals(key) || LOGGING_PATTERN_FILE.equals(key);
    }
}

