/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.spring;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.basic.entity.Authorize;
import org.miaixz.bus.core.center.map.CaseInsensitiveMap;
import org.miaixz.bus.core.lang.annotation.NonNull;
import org.miaixz.bus.core.lang.annotation.Nullable;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.logger.Logger;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.WebUtils;

public class ContextBuilder
extends WebUtils {
    private static final Map<String, Expression> EXPRESSION_CACHE = new ConcurrentHashMap<String, Expression>(64);

    @Nullable
    public static Expression getExpression(@Nullable String expressionString) {
        if (StringKit.isBlank((CharSequence)expressionString)) {
            return null;
        }
        if (EXPRESSION_CACHE.containsKey(expressionString)) {
            return EXPRESSION_CACHE.get(expressionString);
        }
        Expression expression = new SpelExpressionParser().parseExpression(expressionString);
        EXPRESSION_CACHE.put(expressionString, expression);
        return expression;
    }

    @Nullable
    public static <T> T getExpressionValue(@Nullable Object root, @Nullable String expressionString, @NonNull Class<? extends T> clazz) {
        if (root == null) {
            return null;
        }
        Expression expression = ContextBuilder.getExpression(expressionString);
        if (expression == null) {
            return null;
        }
        return (T)expression.getValue(root, clazz);
    }

    @Nullable
    public static <T> T getExpressionValue(@Nullable Object root, @Nullable String expressionString) {
        if (root == null) {
            return null;
        }
        Expression expression = ContextBuilder.getExpression(expressionString);
        if (expression == null) {
            return null;
        }
        return (T)expression.getValue(root);
    }

    public static <T> T[] getExpressionValue(@Nullable Object root, String ... expressionStrings) {
        if (root == null) {
            return null;
        }
        if (ArrayKit.isEmpty((Object[])expressionStrings)) {
            return null;
        }
        Object[] values = new Object[expressionStrings.length];
        for (int i = 0; i < expressionStrings.length; ++i) {
            values[i] = ContextBuilder.getExpressionValue(root, expressionStrings[i]);
        }
        return values;
    }

    @Nullable
    public static boolean getConditionValue(@Nullable Object root, @Nullable String expressionString) {
        Object value = ContextBuilder.getExpressionValue(root, expressionString);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() > 0L;
        }
        return true;
    }

    @Nullable
    public static boolean getConditionValue(@Nullable Object root, String ... expressionStrings) {
        if (root == null) {
            return false;
        }
        if (ArrayKit.isEmpty((Object[])expressionStrings)) {
            return false;
        }
        for (String expressionString : expressionStrings) {
            if (ContextBuilder.getConditionValue(root, expressionString)) continue;
            return false;
        }
        return true;
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String getSessionId() {
        HttpServletRequest request = ContextBuilder.getRequest();
        if (null != request && null != request.getSession(false)) {
            return request.getSession(false).getId();
        }
        return null;
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            headerMap.put(name, value);
        }
        return headerMap;
    }

    public static Map<String, String> getParameters(HttpServletRequest request) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getParameter(name);
            parameterMap.put(name, value);
        }
        return parameterMap;
    }

    public static Authorize getCurrentUser() {
        HttpServletRequest request = ContextBuilder.getRequest();
        String user = null != request && !StringKit.isEmpty((CharSequence)request.getHeader("x_user_id")) ? request.getHeader("x_user_id") : ContextBuilder.getThreadPoolContextValue("x_user_id");
        if (StringKit.isEmpty((CharSequence)user)) {
            return null;
        }
        return (Authorize)JsonKit.toPojo((String)UrlDecoder.decode((String)user, (Charset)org.miaixz.bus.core.lang.Charset.UTF_8), Authorize.class);
    }

    public static String getTenantId() {
        HttpServletRequest request = ContextBuilder.getRequest();
        try {
            if (null != request && !StringKit.isEmpty((CharSequence)request.getHeader("x_tenant_id"))) {
                return request.getHeader("x_tenant_id");
            }
            Authorize authorize = ContextBuilder.getCurrentUser();
            if (null != authorize) {
                return authorize.getX_tenant_id();
            }
            String tenantId = ContextBuilder.getThreadPoolContextValue("x_tenant_id");
            return tenantId;
        }
        catch (Exception e) {
            Logger.error((String)"\u83b7\u53d6\u5f53\u524d\u79df\u6237\u5931\u8d25:", (Object[])new Object[]{e});
            return null;
        }
    }

    private static String getThreadPoolContextValue(String headerKey) {
        Map<String, String> headers = RequestHeaderContext.get();
        if (null != headers) {
            CaseInsensitiveMap headersMap = new CaseInsensitiveMap(headers);
            return (String)headersMap.get(headerKey);
        }
        return null;
    }

    static class RequestHeaderContext {
        public static final ThreadLocal<Map<String, String>> MAP_THREAD_LOCAL = new ThreadLocal();

        RequestHeaderContext() {
        }

        public static void set(Map<String, String> map) {
            MAP_THREAD_LOCAL.set(map);
        }

        public static Map<String, String> get() {
            return MAP_THREAD_LOCAL.get();
        }

        public static void remove() {
            MAP_THREAD_LOCAL.remove();
        }
    }
}

