/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.word;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;

public class DocxTable {
    public static XWPFTable createTable(XWPFDocument doc) {
        return DocxTable.createTable(doc, null);
    }

    public static XWPFTable createTable(XWPFDocument doc, Iterable<?> data) {
        Assert.notNull((Object)doc, (String)"XWPFDocument must be not null !", (Object[])new Object[0]);
        XWPFTable table = doc.createTable();
        table.removeRow(0);
        return DocxTable.writeTable(table, data);
    }

    public static XWPFTable writeTable(XWPFTable table, Iterable<?> data) {
        Assert.notNull((Object)table, (String)"XWPFTable must be not null !", (Object[])new Object[0]);
        if (IteratorKit.isEmpty(data)) {
            return table;
        }
        boolean isFirst = true;
        for (Object rowData : data) {
            DocxTable.writeRow(table.createRow(), rowData, isFirst);
            if (!isFirst) continue;
            isFirst = false;
        }
        return table;
    }

    public static void writeRow(XWPFTableRow row, Object rowBean, boolean isWriteKeyAsHead) {
        Map rowMap;
        if (rowBean instanceof Iterable) {
            DocxTable.writeRow(row, (Iterable)rowBean);
            return;
        }
        if (rowBean instanceof Map) {
            rowMap = (Map)rowBean;
        } else if (BeanKit.isWritableBean(rowBean.getClass())) {
            rowMap = BeanKit.beanToMap((Object)rowBean, new LinkedHashMap(), (boolean)false, (boolean)false);
        } else {
            DocxTable.writeRow(row, ListKit.of((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
            return;
        }
        DocxTable.writeRow(row, rowMap, isWriteKeyAsHead);
    }

    public static void writeRow(XWPFTableRow row, Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        if (MapKit.isEmpty(rowMap)) {
            return;
        }
        if (isWriteKeyAsHead) {
            DocxTable.writeRow(row, rowMap.keySet());
            row = row.getTable().createRow();
        }
        DocxTable.writeRow(row, rowMap.values());
    }

    public static void writeRow(XWPFTableRow row, Iterable<?> rowData) {
        int index = 0;
        for (Object cellData : rowData) {
            XWPFTableCell cell = DocxTable.getOrCreateCell(row, index);
            cell.setText(Convert.toString(cellData));
            ++index;
        }
    }

    public static XWPFTableRow getOrCreateRow(XWPFTable table, int index) {
        XWPFTableRow row = table.getRow(index);
        if (null == row) {
            row = table.createRow();
        }
        return row;
    }

    public static XWPFTableCell getOrCreateCell(XWPFTableRow row, int index) {
        XWPFTableCell cell = row.getCell(index);
        if (null == cell) {
            cell = row.createCell();
        }
        return cell;
    }
}

