/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.xyz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class WorkbookKit {
    public static Workbook createBook(String excelFilePath) {
        return WorkbookKit.createBook(excelFilePath, false);
    }

    public static Workbook createBook(String excelFilePath, boolean readOnly) {
        return WorkbookKit.createBook(FileKit.file((String)excelFilePath), null, readOnly);
    }

    public static Workbook createBook(File excelFile) {
        return WorkbookKit.createBook(excelFile, false);
    }

    public static Workbook createBook(File excelFile, boolean readOnly) {
        return WorkbookKit.createBook(excelFile, null, readOnly);
    }

    public static Workbook createBookForWriter(File excelFile) {
        if (null == excelFile) {
            return WorkbookKit.createBook(true);
        }
        if (excelFile.exists()) {
            return WorkbookKit.createBook(FileKit.getInputStream((File)excelFile));
        }
        return WorkbookKit.createBook(StringKit.endWithIgnoreCase((CharSequence)excelFile.getName(), (CharSequence)".xlsx"));
    }

    public static Workbook createBook(File excelFile, String password) {
        return WorkbookKit.createBook(excelFile, password, false);
    }

    public static Workbook createBook(File excelFile, String password, boolean readOnly) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password, (boolean)readOnly);
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static Workbook createBook(InputStream in) {
        return WorkbookKit.createBook(in, null);
    }

    public static Workbook createBook(InputStream in, String password) {
        Workbook workbook;
        try {
            workbook = WorkbookFactory.create((InputStream)IoKit.toMarkSupport((InputStream)in), (String)password);
        }
        catch (Exception e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return workbook;
    }

    public static Workbook createBook(boolean isXlsx) {
        try {
            return WorkbookFactory.create((boolean)isXlsx);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath) {
        return WorkbookKit.createSXSSFBook(excelFilePath, false);
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath, boolean readOnly) {
        return WorkbookKit.createSXSSFBook(FileKit.file((String)excelFilePath), null, readOnly);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile) {
        return WorkbookKit.createSXSSFBook(excelFile, false);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, boolean readOnly) {
        return WorkbookKit.createSXSSFBook(excelFile, null, readOnly);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password) {
        return WorkbookKit.createSXSSFBook(excelFile, password, false);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password, boolean readOnly) {
        return WorkbookKit.toSXSSFBook(WorkbookKit.createBook(excelFile, password, readOnly));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in) {
        return WorkbookKit.createSXSSFBook(in, null);
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password) {
        return WorkbookKit.toSXSSFBook(WorkbookKit.createBook(in, password));
    }

    public static SXSSFWorkbook createSXSSFBook() {
        return new SXSSFWorkbook();
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize) {
        return new SXSSFWorkbook(rowAccessWindowSize);
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        return new SXSSFWorkbook(null, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
    }

    public static void writeBook(Workbook book, OutputStream out) throws InternalException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private static SXSSFWorkbook toSXSSFBook(Workbook book) {
        if (book instanceof SXSSFWorkbook) {
            return (SXSSFWorkbook)book;
        }
        if (book instanceof XSSFWorkbook) {
            return new SXSSFWorkbook((XSSFWorkbook)book);
        }
        throw new InternalException("The input is not a [xlsx] format.");
    }
}

