/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.xyz;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.lang.exception.DependencyException;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.exception.RevisedException;
import org.miaixz.bus.core.lang.exception.TerminateException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.office.Builder;
import org.miaixz.bus.office.excel.sax.CellDataType;
import org.miaixz.bus.office.excel.sax.Excel03SaxReader;
import org.miaixz.bus.office.excel.sax.Excel07SaxReader;
import org.miaixz.bus.office.excel.sax.ExcelSaxReader;
import org.miaixz.bus.office.excel.sax.handler.RowHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExcelSaxKit {
    public static ExcelSaxReader<?> createSaxReader(boolean isXlsx, RowHandler rowHandler) {
        return isXlsx ? new Excel07SaxReader(rowHandler) : new Excel03SaxReader(rowHandler);
    }

    public static Object getDataValue(CellDataType cellDataType, String value, SharedStrings sharedStrings, String numFmtString) {
        if (null == value) {
            return null;
        }
        if (null == cellDataType) {
            cellDataType = CellDataType.NULL;
        }
        Object result = null;
        switch (cellDataType) {
            case BOOL: {
                result = value.charAt(0) != '0';
                break;
            }
            case ERROR: {
                result = StringKit.format((CharSequence)"\\\"ERROR: {} ", (Object[])new Object[]{value});
                break;
            }
            case FORMULA: {
                result = StringKit.format((CharSequence)"\"{}\"", (Object[])new Object[]{value});
                break;
            }
            case INLINESTR: {
                result = new XSSFRichTextString(value).toString();
                break;
            }
            case SSTINDEX: {
                try {
                    int index = Integer.parseInt(value);
                    result = sharedStrings.getItemAt(index).getString();
                }
                catch (NumberFormatException e) {
                    result = value;
                }
                break;
            }
            case DATE: {
                try {
                    result = ExcelSaxKit.getDateValue(value);
                }
                catch (Exception e) {
                    result = value;
                }
                break;
            }
            default: {
                try {
                    result = ExcelSaxKit.getNumberValue(value, numFmtString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (null != result) break;
                result = value;
            }
        }
        return result;
    }

    public static String formatCellContent(String value, int numFmtIndex, String numFmtString) {
        if (null != numFmtString) {
            try {
                value = new DataFormatter().formatRawCellContents(Double.parseDouble(value), numFmtIndex, numFmtString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static int countNullCell(String preRef, String ref) {
        String preXfd = ((String)ObjectKit.defaultIfNull((Object)preRef, (Object)"@")).replaceAll("\\d+", "");
        String xfd = ((String)ObjectKit.defaultIfNull((Object)ref, (Object)"@")).replaceAll("\\d+", "");
        preXfd = StringKit.fillBefore((String)preXfd, (char)'@', (int)3);
        xfd = StringKit.fillBefore((String)xfd, (char)'@', (int)3);
        char[] preLetter = preXfd.toCharArray();
        char[] letter = xfd.toCharArray();
        int res = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (letter[2] - preLetter[2]);
        return res - 1;
    }

    public static void readFrom(InputStream xmlDocStream, ContentHandler handler) throws DependencyException, InternalException, RevisedException {
        XMLReader xmlReader;
        try {
            xmlReader = XMLHelper.newXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            if (e.getMessage().contains("org.apache.xerces.parsers.SAXParser")) {
                throw new DependencyException((Throwable)e, "You need to add 'xerces:xercesImpl' to your project and version >= 2.11.0", new Object[0]);
            }
            throw new InternalException((Throwable)e);
        }
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.parse(new InputSource(xmlDocStream));
        }
        catch (IOException e) {
            throw new RevisedException((Throwable)e);
        }
        catch (SAXException e) {
            throw new InternalException((Throwable)e);
        }
        catch (TerminateException terminateException) {
            // empty catch block
        }
    }

    public static boolean isDateFormat(CellValueRecordInterface cell, FormatTrackingHSSFListener formatListener) {
        int formatIndex = formatListener.getFormatIndex(cell);
        String formatString = formatListener.getFormatString(cell);
        return ExcelSaxKit.isDateFormat(formatIndex, formatString);
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        return Builder.isDateFormat(formatIndex, formatString);
    }

    public static DateTime getDateValue(String value) {
        return ExcelSaxKit.getDateValue(Double.parseDouble(value));
    }

    public static DateTime getDateValue(double value) {
        return DateKit.date((Date)DateUtil.getJavaDate((double)value, (boolean)false));
    }

    public static Object getNumberOrDateValue(CellValueRecordInterface cell, double value, FormatTrackingHSSFListener formatListener) {
        if (ExcelSaxKit.isDateFormat(cell, formatListener)) {
            return ExcelSaxKit.getDateValue(value);
        }
        return ExcelSaxKit.getNumberValue(value, formatListener.getFormatString(cell));
    }

    private static Number getNumberValue(String value, String numFmtString) {
        if (StringKit.isBlank((CharSequence)value)) {
            return null;
        }
        double number = Double.parseDouble(value);
        if (StringKit.contains((CharSequence)value, (char)'.') && !value.equals(Double.toString(number))) {
            return MathKit.toBigDecimal((String)value);
        }
        return ExcelSaxKit.getNumberValue(number, numFmtString);
    }

    private static Number getNumberValue(double numValue, String numFmtString) {
        long longPart;
        if (null != numFmtString && !StringKit.contains((CharSequence)numFmtString, (char)'.') && (double)(longPart = (long)numValue) == numValue) {
            return longPart;
        }
        return numValue;
    }
}

