/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.xyz;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.office.excel.cell.MergedCell;
import org.miaixz.bus.office.excel.cell.NullCell;
import org.miaixz.bus.office.excel.cell.editors.CellEditor;
import org.miaixz.bus.office.excel.cell.editors.TrimEditor;
import org.miaixz.bus.office.excel.cell.setters.CellSetterFactory;
import org.miaixz.bus.office.excel.cell.values.CompositeCellValue;
import org.miaixz.bus.office.excel.style.StyleSet;
import org.miaixz.bus.office.excel.xyz.RowKit;
import org.miaixz.bus.office.excel.xyz.SheetKit;
import org.miaixz.bus.office.excel.xyz.StyleKit;

public class CellKit {
    public static Object getCellValue(Cell cell) {
        return CellKit.getCellValue(cell, false);
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        if (null == cell) {
            return null;
        }
        return CellKit.getCellValue(cell, cell.getCellType(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        return CellKit.getCellValue(cell, null, cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return CellKit.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        return CompositeCellValue.of(cell, cellType, cellEditor).getValue();
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        CellStyle cellStyle = null;
        if (null != styleSet) {
            cellStyle = styleSet.getStyleFor(new CellReference(cell), value, isHeader);
        }
        CellKit.setCellValue(cell, value, cellStyle, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle style, CellEditor cellEditor) {
        cell.setCellStyle(style);
        CellKit.setCellValue(cell, value, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        if (null != cellEditor) {
            value = cellEditor.edit(cell, value);
        }
        CellKit.setCellValue(cell, value);
    }

    public static void setCellValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        if (CellType.BLANK != cell.getCellType()) {
            cell.setBlank();
        }
        CellSetterFactory.createCellSetter(value).setValue(cell);
    }

    public static Cell getOrCreateCell(Sheet sheet, int x, int y) {
        return CellKit.getCell(sheet, x, y, true);
    }

    public static Cell getCell(Sheet sheet, int x, int y, boolean isCreateIfNotExist) {
        Row row;
        Row row2 = row = isCreateIfNotExist ? RowKit.getOrCreateRow(sheet, y) : sheet.getRow(y);
        if (null != row) {
            return isCreateIfNotExist ? CellKit.getOrCreateCell(row, x) : row.getCell(x);
        }
        return null;
    }

    public static Cell getCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            return new NullCell(row, cellIndex);
        }
        return cell;
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return CellKit.isMergedRegion(sheet, cellReference.getCol(), cellReference.getRow());
    }

    public static boolean isMergedRegion(Cell cell) {
        return CellKit.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return CellKit.mergingCells(sheet, cellRangeAddress, null);
    }

    public static int mergingCells(Sheet sheet, CellRangeAddress cellRangeAddress, CellStyle cellStyle) {
        if (cellRangeAddress.getNumberOfCells() <= 1) {
            return -1;
        }
        StyleKit.setBorderStyle(sheet, cellRangeAddress, cellStyle);
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static Cell getFirstCellOfMerged(Cell cell) {
        if (null == cell) {
            return null;
        }
        MergedCell mergedCell = CellKit.getMergedCell(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
        if (null != mergedCell) {
            return mergedCell.getFirst();
        }
        return cell;
    }

    public static MergedCell getMergedCell(Sheet sheet, int x, int y) {
        if (null == sheet) {
            return null;
        }
        CellRangeAddress mergedRegion = SheetKit.getMergedRegion(sheet, x, y);
        if (null != mergedRegion) {
            return MergedCell.of(CellKit.getCell(sheet, mergedRegion.getFirstColumn(), mergedRegion.getFirstRow(), false), mergedRegion);
        }
        return null;
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor) {
        CellKit.setComment(cell, commentText, commentAuthor, null);
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor, ClientAnchor anchor) {
        Sheet sheet = cell.getSheet();
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        if (anchor == null) {
            anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex() + 1);
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 2);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        }
        Comment comment = sheet.createDrawingPatriarch().createCellComment(anchor);
        comment.setAddress(cell.getAddress());
        comment.setString(factory.createRichTextString(commentText));
        if (null != commentAuthor) {
            comment.setAuthor(commentAuthor);
        }
        cell.setCellComment(comment);
    }

    public static void remove(Cell cell) {
        if (null != cell) {
            cell.getRow().removeCell(cell);
        }
    }

    public static CellRangeAddress of(String ref) {
        return CellRangeAddress.valueOf((String)ref);
    }

    public static CellRangeAddress of(int firstRow, int lastRow, int firstCol, int lastCol) {
        return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
    }

    public static CellRangeAddress ofSingleRow(int row, int lastCol) {
        return CellKit.ofSingleRow(row, 0, lastCol);
    }

    public static CellRangeAddress ofSingleRow(int row, int firstCol, int lastCol) {
        return CellKit.of(row, row, firstCol, lastCol);
    }

    public static CellRangeAddress ofSingleColumn(int lastRow, int col) {
        return CellKit.ofSingleColumn(0, lastRow, col);
    }

    public static CellRangeAddress ofSingleColumn(int firstRow, int lastRow, int col) {
        return CellKit.of(firstRow, lastRow, col, col);
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return CellKit.getCellRangeAddress(sheet, cellReference.getCol(), cellReference.getRow());
    }

    public static CellRangeAddress getCellRangeAddress(Cell cell) {
        return CellKit.getCellRangeAddress(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, int x, int y) {
        if (sheet != null) {
            int sheetMergeCount = sheet.getNumMergedRegions();
            for (int i = 0; i < sheetMergeCount; ++i) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
                return ca;
            }
        }
        return null;
    }

    public static String indexToColName(int index) {
        int remainder;
        if (index < 0) {
            return null;
        }
        StringBuilder colName = StringKit.builder();
        do {
            if (colName.length() > 0) {
                --index;
            }
            remainder = index % 26;
            colName.append((char)(remainder + 65));
        } while ((index = (index - remainder) / 26) > 0);
        return colName.reverse().toString();
    }

    public static int colNameToIndex(String colName) {
        char c;
        int length = colName.length();
        int index = -1;
        for (int i = 0; i < length && !Character.isDigit(c = Character.toUpperCase(colName.charAt(i))); ++i) {
            index = (index + 1) * 26 + c - 65;
        }
        return index;
    }

    public static CellReference toCellReference(String locationRef) {
        return new CellReference(locationRef);
    }
}

