/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.writer;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.office.excel.cell.VirtualCell;
import org.miaixz.bus.office.excel.xyz.CellKit;
import org.miaixz.bus.office.excel.xyz.SheetKit;

public class TemplateContext {
    private static final Pattern VAR_PATTERN = Pattern.compile("(?<!\\\\)\\{([.$_a-zA-Z]+\\d*[.$_a-zA-Z]*)}");
    private static final Pattern ESCAPE_VAR_PATTERN = Pattern.compile("\\\\\\{([.$_a-zA-Z]+\\d*[.$_a-zA-Z]*)\\\\}");
    private final Map<String, Cell> varMap = new LinkedHashMap<String, Cell>();

    public TemplateContext(Sheet templateSheet) {
        this.init(templateSheet);
    }

    public Cell getCell(String varName) {
        return this.varMap.get(varName);
    }

    public int getBottomRowIndex(Object rowDataBean) {
        AtomicInteger bottomRowIndex = new AtomicInteger(-1);
        this.varMap.forEach((name, cell) -> {
            if (null != BeanKit.getProperty((Object)rowDataBean, (String)name)) {
                if (cell instanceof VirtualCell) {
                    bottomRowIndex.set(Math.max(bottomRowIndex.get(), cell.getRowIndex()));
                } else if (bottomRowIndex.get() < 0) {
                    bottomRowIndex.set(0);
                }
            }
        });
        return bottomRowIndex.get();
    }

    public void fill(Object rowDataBean, boolean isListVar) {
        Map<String, Cell> varMap = this.varMap;
        varMap.forEach((name, cell) -> {
            if (null == cell) {
                return;
            }
            String templateStr = cell.getStringCellValue();
            if (this.fill((Cell)cell, (String)name, rowDataBean)) {
                this.putNext((String)name, (Cell)cell, templateStr, isListVar);
            }
        });
        if (!isListVar) {
            MapKit.removeNullValue(varMap);
        }
    }

    private void putNext(String name, Cell currentCell, String templateStr, boolean isListVar) {
        if (isListVar) {
            VirtualCell next = new VirtualCell(currentCell, currentCell.getColumnIndex(), currentCell.getRowIndex() + 1, templateStr);
            this.varMap.put(name, (Cell)next);
        } else {
            this.varMap.put(name, null);
        }
    }

    private boolean fill(Cell cell, String name, Object rowDataBean) {
        Object cellValue;
        String templateStr = cell.getStringCellValue();
        if (cell instanceof VirtualCell) {
            Cell newCell = CellKit.getCell(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex(), true);
            Assert.notNull((Object)newCell, (String)"Can not get or create cell at {},{}", (Object[])new Object[]{cell.getColumnIndex(), cell.getRowIndex()});
            newCell.setCellStyle(cell.getCellStyle());
            cell = newCell;
        }
        if (StringKit.equals((CharSequence)name, (CharSequence)StringKit.unWrap((CharSequence)templateStr, (String)"{", (String)"}")) ? null == (cellValue = BeanKit.getProperty((Object)rowDataBean, (String)name)) : ObjectKit.equals((Object)(cellValue = StringKit.formatByBean((CharSequence)templateStr, (Object)rowDataBean, (boolean)true)), (Object)templateStr)) {
            return false;
        }
        CellKit.setCellValue(cell, cellValue);
        return true;
    }

    private void init(Sheet templateSheet) {
        SheetKit.walk(templateSheet, (cell, ctx) -> {
            if (CellType.STRING == cell.getCellType()) {
                String text;
                String cellValue = cell.getStringCellValue();
                List vars = PatternKit.findAllGroup1((Pattern)VAR_PATTERN, (CharSequence)cellValue);
                if (CollKit.isNotEmpty((Collection)vars)) {
                    for (String var : vars) {
                        this.varMap.put(var, cell);
                    }
                }
                if (!StringKit.equals((CharSequence)cellValue, (CharSequence)(text = PatternKit.replaceAll((CharSequence)cellValue, (Pattern)ESCAPE_VAR_PATTERN, (FunctionX & Serializable)matcher -> "{" + matcher.group(1) + "}")))) {
                    cell.setCellValue(text);
                }
            }
        });
    }

    public String toString() {
        return "TemplateContext{varMap=" + String.valueOf(this.varMap) + "}";
    }
}

