/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.writer;

import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.miaixz.bus.office.excel.writer.ExcelWriteConfig;
import org.miaixz.bus.office.excel.writer.TemplateContext;

public class SheetTemplateWriter {
    private final Sheet sheet;
    private final ExcelWriteConfig config;
    private final TemplateContext templateContext;

    public SheetTemplateWriter(Sheet sheet, ExcelWriteConfig config) {
        this.sheet = sheet;
        this.config = config;
        this.templateContext = new TemplateContext(sheet);
    }

    public SheetTemplateWriter fillOnce(Map<?, ?> rowMap) {
        this.templateContext.fill(rowMap, false);
        return this;
    }

    public SheetTemplateWriter fillRow(Object rowBean) {
        if (this.config.insertRow) {
            int lastRowNum;
            int bottomRowIndex = this.templateContext.getBottomRowIndex(rowBean);
            if (bottomRowIndex < 0) {
                return this;
            }
            if (bottomRowIndex != 0 && bottomRowIndex <= (lastRowNum = this.sheet.getLastRowNum())) {
                this.sheet.shiftRows(bottomRowIndex, this.sheet.getLastRowNum(), 1);
            }
        }
        this.templateContext.fill(rowBean, true);
        return this;
    }
}

