/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.writer;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.miaixz.bus.core.center.map.multi.Table;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.office.excel.RowGroup;
import org.miaixz.bus.office.excel.cell.editors.CellEditor;
import org.miaixz.bus.office.excel.style.StyleSet;
import org.miaixz.bus.office.excel.writer.ExcelWriteConfig;
import org.miaixz.bus.office.excel.xyz.CellKit;
import org.miaixz.bus.office.excel.xyz.RowKit;

public class SheetDataWriter {
    private final Sheet sheet;
    private final ExcelWriteConfig config;
    private final AtomicInteger currentRow;
    private StyleSet styleSet;
    private Map<String, Integer> headerLocationCache;

    public SheetDataWriter(Sheet sheet, ExcelWriteConfig config, StyleSet styleSet) {
        this.sheet = sheet;
        this.config = config;
        this.styleSet = styleSet;
        this.currentRow = new AtomicInteger(0);
    }

    public SheetDataWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public SheetDataWriter setHeaderLocationCache(Map<String, Integer> headerLocationCache) {
        this.headerLocationCache = headerLocationCache;
        return this;
    }

    public SheetDataWriter writeHeader(int x, int y, int rowCount, RowGroup rowGroup) {
        int childrenMaxRowCount;
        String name = rowGroup.getName();
        List<RowGroup> children = rowGroup.getChildren();
        if (null != name) {
            if (CollKit.isNotEmpty(children)) {
                rowCount = Math.max(1, rowCount - rowGroup.childrenMaxRowCount());
            }
            CellRangeAddress cellRangeAddresses = CellKit.of(y, y + rowCount - 1, x, x + rowGroup.maxColumnCount() - 1);
            CellStyle style = rowGroup.getStyle();
            if (null == style && null != this.styleSet) {
                style = this.styleSet.getStyleFor(new CellReference(cellRangeAddresses.getFirstRow(), cellRangeAddresses.getFirstColumn()), name, true);
            }
            CellKit.mergingCells(this.sheet, cellRangeAddresses, style);
            Cell cell = CellKit.getOrCreateCell(this.sheet, cellRangeAddresses.getFirstColumn(), cellRangeAddresses.getFirstRow());
            if (null != cell) {
                CellKit.setCellValue(cell, name, style, this.config.getCellEditor());
            }
            y += rowCount;
        }
        if ((childrenMaxRowCount = rowGroup.childrenMaxRowCount()) > 0) {
            for (RowGroup child : children) {
                this.writeHeader(x, y, childrenMaxRowCount, child);
                x += child.maxColumnCount();
            }
        }
        return this;
    }

    public SheetDataWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        Map rowMap;
        ExcelWriteConfig config = this.config;
        if (rowBean instanceof Map) {
            rowMap = MapKit.isNotEmpty(config.getHeaderAlias()) ? MapKit.newTreeMap((Map)((Map)rowBean), config.getCachedAliasComparator()) : (Map)rowBean;
        } else {
            if (rowBean instanceof Iterable) {
                return this.writeRow((Iterable)rowBean);
            }
            if (rowBean instanceof Hyperlink) {
                return this.writeRow(ListKit.of((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
            }
            if (BeanKit.isReadableBean(rowBean.getClass())) {
                rowMap = MapKit.isEmpty(config.getHeaderAlias()) ? BeanKit.beanToMap((Object)rowBean, new LinkedHashMap(), (boolean)false, (boolean)false) : BeanKit.beanToMap((Object)rowBean, new TreeMap(config.getCachedAliasComparator()), (boolean)false, (boolean)false);
            } else {
                return this.writeRow(ListKit.of((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
            }
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public SheetDataWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        if (MapKit.isEmpty(rowMap)) {
            this.passAndGet();
            return this;
        }
        Table<?, ?, ?> aliasTable = this.config.aliasTable(rowMap);
        if (isWriteKeyAsHead) {
            this.writeHeaderRow(aliasTable.columnKeys());
            int i = 0;
            for (Object key : aliasTable.rowKeySet()) {
                this.headerLocationCache.putIfAbsent(StringKit.toString(key), i);
                ++i;
            }
        }
        if (MapKit.isNotEmpty(this.headerLocationCache)) {
            Row row = RowKit.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
            CellEditor cellEditor = this.config.getCellEditor();
            for (Table.Cell cell : aliasTable) {
                Integer columnIndex = this.getColumnIndex(cell);
                if (null == columnIndex) continue;
                CellKit.setCellValue(CellKit.getOrCreateCell(row, columnIndex), cell.getValue(), this.styleSet, false, cellEditor);
            }
        } else {
            this.writeRow(aliasTable.values());
        }
        return this;
    }

    public SheetDataWriter writeHeaderRow(Iterable<?> rowData) {
        int rowNum = this.currentRow.getAndIncrement();
        Row row = this.config.insertRow ? this.sheet.createRow(rowNum) : RowKit.getOrCreateRow(this.sheet, rowNum);
        LinkedHashMap<String, Integer> headerLocationCache = new LinkedHashMap<String, Integer>();
        CellEditor cellEditor = this.config.getCellEditor();
        int i = 0;
        for (Object value : rowData) {
            Cell cell = CellKit.getOrCreateCell(row, i);
            CellKit.setCellValue(cell, value, this.styleSet, true, cellEditor);
            headerLocationCache.put(StringKit.toString(value), i);
            ++i;
        }
        return this.setHeaderLocationCache(headerLocationCache);
    }

    public SheetDataWriter writeRow(Iterable<?> rowData) {
        int rowNum = this.currentRow.getAndIncrement();
        Row row = this.config.insertRow ? this.sheet.createRow(rowNum) : RowKit.getOrCreateRow(this.sheet, rowNum);
        RowKit.writeRow(row, rowData, this.styleSet, false, this.config.getCellEditor());
        return this;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public SheetDataWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public int passAndGet() {
        return this.currentRow.incrementAndGet();
    }

    public int passRowsAndGet(int rowNum) {
        return this.currentRow.addAndGet(rowNum);
    }

    public SheetDataWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    private Integer getColumnIndex(Table.Cell<?, ?, ?> cell) {
        Integer location = this.headerLocationCache.get(StringKit.toString((Object)cell.getRowKey()));
        if (null == location) {
            location = this.headerLocationCache.get(StringKit.toString((Object)cell.getColumnKey()));
        }
        return location;
    }
}

