/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.writer;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.IgnoredErrorType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.office.excel.ExcelBase;
import org.miaixz.bus.office.excel.RowGroup;
import org.miaixz.bus.office.excel.SimpleAnchor;
import org.miaixz.bus.office.excel.shape.ExcelPictureType;
import org.miaixz.bus.office.excel.style.DefaultStyleSet;
import org.miaixz.bus.office.excel.style.LineStyle;
import org.miaixz.bus.office.excel.style.ShapeConfig;
import org.miaixz.bus.office.excel.style.StyleSet;
import org.miaixz.bus.office.excel.writer.ExcelDrawing;
import org.miaixz.bus.office.excel.writer.ExcelWriteConfig;
import org.miaixz.bus.office.excel.writer.SheetDataWriter;
import org.miaixz.bus.office.excel.writer.SheetTemplateWriter;
import org.miaixz.bus.office.excel.xyz.CellKit;
import org.miaixz.bus.office.excel.xyz.SheetKit;
import org.miaixz.bus.office.excel.xyz.WorkbookKit;

public class ExcelWriter
extends ExcelBase<ExcelWriter, ExcelWriteConfig> {
    private StyleSet styleSet;
    private SheetDataWriter sheetDataWriter;
    private SheetTemplateWriter sheetTemplateWriter;

    public ExcelWriter() {
        this(true);
    }

    public ExcelWriter(boolean isXlsx) {
        this(WorkbookKit.createBook(isXlsx), (String)null);
    }

    public ExcelWriter(String templateFilePath) {
        this(templateFilePath, (String)null);
    }

    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(WorkbookKit.createBook(isXlsx), sheetName);
    }

    public ExcelWriter(String templateFilePath, String sheetName) {
        this(FileKit.file((String)templateFilePath), sheetName);
    }

    public ExcelWriter(File templateFile) {
        this(templateFile, (String)null);
    }

    public ExcelWriter(File templateFile, String sheetName) {
        this(WorkbookKit.createBookForWriter(templateFile), sheetName);
        if (!FileKit.exists((File)templateFile)) {
            this.targetFile = templateFile;
        } else {
            this.sheetTemplateWriter = new SheetTemplateWriter(this.sheet, (ExcelWriteConfig)this.config);
        }
    }

    public ExcelWriter(Workbook templateWorkbook, String sheetName) {
        this(SheetKit.getOrCreateSheet(templateWorkbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        super(new ExcelWriteConfig(), sheet);
        this.styleSet = new DefaultStyleSet(this.workbook);
    }

    public static void addSelect(Sheet sheet, CellRangeAddressList regions, String ... selectList) {
        DataValidationConstraint constraint;
        DataValidationHelper validationHelper = sheet.getDataValidationHelper();
        DataValidation dataValidation = validationHelper.createValidation(constraint = validationHelper.createExplicitListConstraint(selectList), regions);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    @Override
    public ExcelWriter setConfig(ExcelWriteConfig config) {
        return (ExcelWriter)super.setConfig(config);
    }

    public ExcelWriter reset() {
        this.sheetDataWriter = null;
        return this;
    }

    @Override
    public void close() {
        if (null != this.targetFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.reset();
        this.styleSet = null;
    }

    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        super.setSheet(sheetIndex);
        return this.reset();
    }

    @Override
    public ExcelWriter setSheet(String sheetName) {
        super.setSheet(sheetName);
        return this.reset();
    }

    @Override
    public ExcelWriter renameSheet(String sheetName) {
        return this.renameSheet(this.workbook.getSheetIndex(this.sheet), sheetName);
    }

    public ExcelWriter renameSheet(int sheet, String sheetName) {
        this.workbook.setSheetName(sheet, sheetName);
        return this;
    }

    public ExcelWriter autoSizeColumnAll(boolean useMergedCells, float widthRatio) {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.autoSizeColumn(i, useMergedCells, widthRatio);
        }
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells, float widthRatio) {
        if (widthRatio > 0.0f) {
            this.sheet.setColumnWidth(columnIndex, (int)((float)this.sheet.getColumnWidth(columnIndex) * widthRatio));
        } else {
            this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        }
        return this;
    }

    public ExcelWriter disableDefaultStyle() {
        return this.setStyleSet(null);
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public ExcelWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        if (null != this.sheetDataWriter) {
            this.sheetDataWriter.setStyleSet(styleSet);
        }
        return this;
    }

    public int getCurrentRow() {
        return null == this.sheetDataWriter ? 0 : this.sheetDataWriter.getCurrentRow();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.getSheetDataWriter().setCurrentRow(rowIndex);
        return this;
    }

    public ExcelWriter setCurrentRowToEnd() {
        return this.setCurrentRow(this.getRowCount());
    }

    public ExcelWriter passCurrentRow() {
        this.getSheetDataWriter().passAndGet();
        return this;
    }

    public ExcelWriter passRows(int rowNum) {
        this.getSheetDataWriter().passRowsAndGet(rowNum);
        return this;
    }

    public ExcelWriter resetRow() {
        this.getSheetDataWriter().resetRow();
        return this;
    }

    public ExcelWriter setTargetFile(File targetFile) {
        this.targetFile = targetFile;
        return this;
    }

    public ExcelWriter setFreezePane(int rowSplit) {
        return this.setFreezePane(0, rowSplit);
    }

    public ExcelWriter setFreezePane(int colSplit, int rowSplit) {
        this.getSheet().createFreezePane(colSplit, rowSplit);
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setDefaultRowHeight(int height) {
        return this.setRowHeight(-1, height);
    }

    public ExcelWriter setRowHeight(int rowNum, int height) {
        if (rowNum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            Row row = this.sheet.getRow(rowNum);
            if (null != row) {
                row.setHeightInPoints((float)height);
            }
        }
        return this;
    }

    public ExcelWriter setHeaderOrFooter(String text, EnumValue.Align align, boolean isFooter) {
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (align) {
            case LEFT: {
                headerFooter.setLeft(text);
                break;
            }
            case RIGHT: {
                headerFooter.setRight(text);
                break;
            }
            case CENTER: {
                headerFooter.setCenter(text);
                break;
            }
        }
        return this;
    }

    public ExcelWriter addIgnoredErrors(CellRangeAddress cellRangeAddress, IgnoredErrorType ... ignoredErrorTypes) throws UnsupportedOperationException {
        SheetKit.addIgnoredErrors(this.sheet, cellRangeAddress, ignoredErrorTypes);
        return this;
    }

    public ExcelWriter addSelect(int x, int y, String ... selectList) {
        return this.addSelect(new CellRangeAddressList(y, y, x, x), selectList);
    }

    public ExcelWriter addSelect(CellRangeAddressList regions, String ... selectList) {
        ExcelWriter.addSelect(this.sheet, regions, selectList);
        return this;
    }

    public ExcelWriter addValidationData(DataValidation dataValidation) {
        this.sheet.addValidationData(dataValidation);
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        return this.merge(lastColumn, content, true);
    }

    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        this.checkClosed();
        int rowIndex = this.getCurrentRow();
        this.merge(CellKit.ofSingleRow(rowIndex, lastColumn), content, isSetHeaderStyle);
        if (null != content) {
            this.passCurrentRow();
        }
        return this;
    }

    public ExcelWriter merge(CellRangeAddress cellRangeAddress, Object content, boolean isSetHeaderStyle) {
        this.checkClosed();
        CellStyle style = null;
        if (null != this.styleSet) {
            style = this.styleSet.getStyleFor(new CellReference(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn()), content, isSetHeaderStyle);
        }
        return this.merge(cellRangeAddress, content, style);
    }

    public ExcelWriter merge(CellRangeAddress cellRangeAddress, Object content, CellStyle cellStyle) {
        this.checkClosed();
        CellKit.mergingCells(this.getSheet(), cellRangeAddress, cellStyle);
        if (null != content) {
            Cell cell = this.getOrCreateCell(cellRangeAddress.getFirstColumn(), cellRangeAddress.getFirstRow());
            CellKit.setCellValue(cell, content, cellStyle, ((ExcelWriteConfig)this.config).getCellEditor());
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        return this.write(data, 0 == this.getCurrentRow());
    }

    public ExcelWriter write(Iterable<?> data, boolean isWriteKeyAsHead) {
        this.checkClosed();
        boolean isFirst = true;
        for (Object object : data) {
            this.writeRow(object, isFirst && isWriteKeyAsHead);
            if (!isFirst) continue;
            isFirst = false;
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        this.checkClosed();
        boolean isFirstRow = true;
        for (Object object : data) {
            Map map;
            if (isFirstRow) {
                if (object instanceof Map) {
                    map = new TreeMap(comparator);
                    map.putAll((Map)object);
                } else {
                    map = BeanKit.beanToMap(object, new TreeMap(comparator), (boolean)false, (boolean)false);
                }
            } else {
                map = object instanceof Map ? (TreeMap)object : BeanKit.beanToMap(object, new HashMap(), (boolean)false, (boolean)false);
            }
            this.writeRow(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeader(RowGroup rowGroup) {
        return this.writeHeader(0, this.getCurrentRow(), 1, rowGroup);
    }

    public ExcelWriter writeHeader(int x, int y, int rowCount, RowGroup rowGroup) {
        this.checkClosed();
        this.getSheetDataWriter().writeHeader(x, y, rowCount, rowGroup);
        return this;
    }

    public ExcelWriter writeImg(File imgFile, int col1, int row1, int col2, int row2) {
        return this.writeImg(imgFile, new SimpleAnchor(col1, row1, col2, row2));
    }

    public ExcelWriter writeImg(File imgFile, SimpleAnchor clientAnchor) {
        return this.writeImg(imgFile, ExcelPictureType.getType(imgFile), clientAnchor);
    }

    public ExcelWriter writeImg(File imgFile, ExcelPictureType imgType, SimpleAnchor clientAnchor) {
        return this.writeImg(FileKit.readBytes((File)imgFile), imgType, clientAnchor);
    }

    public ExcelWriter writeImg(byte[] pictureData, ExcelPictureType imgType, SimpleAnchor clientAnchor) {
        ExcelDrawing.drawingPicture(this.sheet, pictureData, imgType, clientAnchor);
        return this;
    }

    public ExcelWriter writeLineShape(SimpleAnchor clientAnchor) {
        return this.writeSimpleShape(clientAnchor, ShapeConfig.of());
    }

    public ExcelWriter writeLineShape(SimpleAnchor clientAnchor, LineStyle lineStyle, int lineWidth, Color lineColor) {
        return this.writeSimpleShape(clientAnchor, ShapeConfig.of().setLineStyle(lineStyle).setLineWidth(lineWidth).setLineColor(lineColor));
    }

    public ExcelWriter writeSimpleShape(SimpleAnchor clientAnchor, ShapeConfig shapeConfig) {
        ExcelDrawing.drawingSimpleShape(this.sheet, clientAnchor, shapeConfig);
        return this;
    }

    public ExcelWriter writeHeaderRow(Iterable<?> rowData) {
        this.checkClosed();
        this.getSheetDataWriter().writeHeaderRow(rowData);
        return this;
    }

    public ExcelWriter fillOnce(Map<?, ?> rowMap) {
        this.checkClosed();
        Assert.notNull((Object)this.sheetTemplateWriter, () -> new InternalException("No template for this writer!"));
        this.sheetTemplateWriter.fillOnce(rowMap);
        return this;
    }

    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        this.checkClosed();
        if (null != this.sheetTemplateWriter) {
            this.sheetTemplateWriter.fillRow(rowBean);
            return this;
        }
        this.getSheetDataWriter().writeRow(rowBean, isWriteKeyAsHead);
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        this.checkClosed();
        this.getSheetDataWriter().writeRow(rowData);
        return this;
    }

    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, boolean isWriteKeyAsHead) {
        return this.writeCol(colMap, 0, isWriteKeyAsHead);
    }

    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, int startColIndex, boolean isWriteKeyAsHead) {
        for (Object k : colMap.keySet()) {
            Iterable<?> v = colMap.get(k);
            if (v == null) continue;
            this.writeCol(isWriteKeyAsHead ? k : null, startColIndex, v, startColIndex != colMap.size() - 1);
            ++startColIndex;
        }
        return this;
    }

    public ExcelWriter writeCol(Object headerVal, Iterable<?> colData, boolean isResetRowIndex) {
        return this.writeCol(headerVal, 0, colData, isResetRowIndex);
    }

    public ExcelWriter writeCol(Object headerVal, int colIndex, Iterable<?> colData, boolean isResetRowIndex) {
        this.checkClosed();
        int currentRowIndex = this.getCurrentRow();
        if (null != headerVal) {
            this.writeCellValue(colIndex, currentRowIndex, headerVal, true);
            ++currentRowIndex;
        }
        for (Object colDatum : colData) {
            this.writeCellValue(colIndex, currentRowIndex, colDatum);
            ++currentRowIndex;
        }
        if (!isResetRowIndex) {
            this.setCurrentRow(currentRowIndex);
        }
        return this;
    }

    public ExcelWriter writeCellValue(String locationRef, Object value) {
        CellReference cellReference = new CellReference(locationRef);
        return this.writeCellValue(cellReference.getCol(), cellReference.getRow(), value);
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        return this.writeCellValue(x, y, value, false);
    }

    public ExcelWriter writeCellValue(int x, int y, Object value, boolean isHeader) {
        Cell cell = this.getOrCreateCell(x, y);
        CellKit.setCellValue(cell, value, this.styleSet, isHeader, ((ExcelWriteConfig)this.config).getCellEditor());
        return this;
    }

    public ExcelWriter setStyle(CellStyle style, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return this.setStyle(style, cellReference.getCol(), cellReference.getRow());
    }

    public ExcelWriter setStyle(CellStyle style, int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        cell.setCellStyle(style);
        return this;
    }

    public ExcelWriter setRowStyle(int y, CellStyle style) {
        this.getOrCreateRow(y).setRowStyle(style);
        return this;
    }

    public ExcelWriter setRowStyleIfHasData(int y, CellStyle style) {
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.setStyle(style, i, y);
        }
        return this;
    }

    public ExcelWriter setColumnStyle(int x, CellStyle style) {
        this.sheet.setDefaultColumnStyle(x, style);
        return this;
    }

    public ExcelWriter setColumnStyleIfHasData(int x, int y, CellStyle style) {
        if (x < 0) {
            throw new IllegalArgumentException("Invalid column number (" + x + ")");
        }
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int rowCount = this.getRowCount();
        for (int i = y; i < rowCount; ++i) {
            this.setStyle(style, x, i);
        }
        return this;
    }

    public ExcelWriter flush() throws InternalException {
        return this.flush(false);
    }

    public ExcelWriter flush(boolean override) throws InternalException {
        Assert.notNull((Object)this.targetFile, (String)"[targetFile] is null, and you must call setTargetFile(File) first.", (Object[])new Object[0]);
        return this.flush(this.targetFile, override);
    }

    public ExcelWriter flush(File targetFile, boolean override) throws InternalException {
        Assert.notNull((Object)targetFile, (String)"targetFile is null!", (Object[])new Object[0]);
        if (FileKit.exists((File)targetFile) && !override) {
            throw new InternalException("File to write exist: " + String.valueOf(targetFile));
        }
        return this.flush(FileKit.getOutputStream((File)targetFile, (OpenOption[])new OpenOption[0]), true);
    }

    public ExcelWriter flush(OutputStream out) throws InternalException {
        return this.flush(out, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws InternalException {
        this.checkClosed();
        try {
            this.workbook.write(out);
            out.flush();
            if (!isCloseOut) return this;
        }
        catch (IOException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        return this;
    }

    private SheetDataWriter getSheetDataWriter() {
        if (null == this.sheetDataWriter) {
            this.sheetDataWriter = new SheetDataWriter(this.sheet, (ExcelWriteConfig)this.config, this.styleSet);
        }
        return this.sheetDataWriter;
    }
}

