/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.writer;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.office.excel.writer.ExcelWriter;
import org.miaixz.bus.office.excel.xyz.SheetKit;
import org.miaixz.bus.office.excel.xyz.WorkbookKit;

public class BigExcelWriter
extends ExcelWriter {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    private boolean isFlushed;

    public BigExcelWriter() {
        this(100);
    }

    public BigExcelWriter(int rowAccessWindowSize) {
        this(WorkbookKit.createSXSSFBook(rowAccessWindowSize), (String)null);
    }

    public BigExcelWriter(int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable, String sheetName) {
        this(WorkbookKit.createSXSSFBook(rowAccessWindowSize, compressTmpFiles, useSharedStringsTable), sheetName);
    }

    public BigExcelWriter(String destFilePath) {
        this(destFilePath, (String)null);
    }

    public BigExcelWriter(int rowAccessWindowSize, String sheetName) {
        this(WorkbookKit.createSXSSFBook(rowAccessWindowSize), sheetName);
    }

    public BigExcelWriter(String destFilePath, String sheetName) {
        this(FileKit.file((String)destFilePath), sheetName);
    }

    public BigExcelWriter(File destFile) {
        this(destFile, (String)null);
    }

    public BigExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? WorkbookKit.createSXSSFBook(destFile) : WorkbookKit.createSXSSFBook(), sheetName);
        this.targetFile = destFile;
    }

    public BigExcelWriter(SXSSFWorkbook workbook, String sheetName) {
        this(SheetKit.getOrCreateSheet((Workbook)workbook, sheetName));
    }

    public BigExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public BigExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells, float widthRatio) {
        SXSSFSheet sheet = (SXSSFSheet)this.sheet;
        sheet.trackColumnForAutoSizing(columnIndex);
        super.autoSizeColumn(columnIndex, useMergedCells, widthRatio);
        sheet.untrackColumnForAutoSizing(columnIndex);
        return this;
    }

    @Override
    public BigExcelWriter autoSizeColumnAll(boolean useMergedCells, float widthRatio) {
        SXSSFSheet sheet = (SXSSFSheet)this.sheet;
        sheet.trackAllColumnsForAutoSizing();
        super.autoSizeColumnAll(useMergedCells, widthRatio);
        sheet.untrackAllColumnsForAutoSizing();
        return this;
    }

    @Override
    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws InternalException {
        if (!this.isFlushed) {
            this.isFlushed = true;
            return super.flush(out, isCloseOut);
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.targetFile && !this.isFlushed) {
            this.flush();
        }
        IoKit.close((Closeable)this.workbook);
        super.closeWithoutFlush();
    }
}

