/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.style;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.miaixz.bus.office.excel.style.StyleSet;
import org.miaixz.bus.office.excel.xyz.StyleKit;

public class DefaultStyleSet
implements StyleSet,
Serializable {
    private static final long serialVersionUID = -1L;
    private final Workbook workbook;
    private final CellStyle headCellStyle;
    private final CellStyle cellStyle;
    private final CellStyle cellStyleForNumber;
    private final CellStyle cellStyleForDate;
    private final CellStyle cellStyleForHyperlink;

    public DefaultStyleSet(Workbook workbook) {
        this.workbook = workbook;
        this.headCellStyle = StyleKit.createHeadCellStyle(workbook);
        this.cellStyle = StyleKit.createDefaultCellStyle(workbook);
        this.cellStyleForNumber = StyleKit.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForNumber.setDataFormat((short)0);
        this.cellStyleForDate = StyleKit.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForDate.setDataFormat((short)22);
        this.cellStyleForHyperlink = StyleKit.cloneCellStyle(workbook, this.cellStyle);
        Font font = workbook.createFont();
        font.setUnderline((byte)1);
        font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        this.cellStyleForHyperlink.setFont(font);
    }

    @Override
    public CellStyle getStyleFor(CellReference reference, Object cellValue, boolean isHeader) {
        CellStyle style = null;
        if (isHeader && null != this.headCellStyle) {
            style = this.headCellStyle;
        } else if (null != this.cellStyle) {
            style = this.cellStyle;
        }
        if (cellValue instanceof Date || cellValue instanceof TemporalAccessor || cellValue instanceof Calendar) {
            if (null != this.cellStyleForDate) {
                style = this.cellStyleForDate;
            }
        } else if (cellValue instanceof Number) {
            if ((cellValue instanceof Double || cellValue instanceof Float || cellValue instanceof BigDecimal) && null != this.cellStyleForNumber) {
                style = this.cellStyleForNumber;
            }
        } else if (cellValue instanceof Hyperlink && null != this.cellStyleForHyperlink) {
            style = this.cellStyleForHyperlink;
        }
        return style;
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public CellStyle getCellStyleForNumber() {
        return this.cellStyleForNumber;
    }

    public CellStyle getCellStyleForDate() {
        return this.cellStyleForDate;
    }

    public CellStyle getCellStyleForHyperlink() {
        return this.cellStyleForHyperlink;
    }

    public DefaultStyleSet setBorder(BorderStyle borderSize, IndexedColors colorIndex) {
        StyleKit.setBorder(this.headCellStyle, borderSize, colorIndex);
        StyleKit.setBorder(this.cellStyle, borderSize, colorIndex);
        StyleKit.setBorder(this.cellStyleForNumber, borderSize, colorIndex);
        StyleKit.setBorder(this.cellStyleForDate, borderSize, colorIndex);
        StyleKit.setBorder(this.cellStyleForHyperlink, borderSize, colorIndex);
        return this;
    }

    public DefaultStyleSet setAlign(HorizontalAlignment halign, VerticalAlignment valign) {
        StyleKit.setAlign(this.headCellStyle, halign, valign);
        StyleKit.setAlign(this.cellStyle, halign, valign);
        StyleKit.setAlign(this.cellStyleForNumber, halign, valign);
        StyleKit.setAlign(this.cellStyleForDate, halign, valign);
        StyleKit.setAlign(this.cellStyleForHyperlink, halign, valign);
        return this;
    }

    public DefaultStyleSet setBackgroundColor(IndexedColors backgroundColor, boolean withHeadCell) {
        if (withHeadCell) {
            StyleKit.setColor(this.headCellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        }
        StyleKit.setColor(this.cellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleKit.setColor(this.cellStyleForNumber, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleKit.setColor(this.cellStyleForDate, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleKit.setColor(this.cellStyleForHyperlink, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        return this;
    }

    public DefaultStyleSet setFont(short color, short fontSize, String fontName, boolean ignoreHead) {
        Font font = StyleKit.createFont(this.workbook, color, fontSize, fontName);
        return this.setFont(font, ignoreHead);
    }

    public DefaultStyleSet setFont(Font font, boolean ignoreHead) {
        if (!ignoreHead) {
            this.headCellStyle.setFont(font);
        }
        this.cellStyle.setFont(font);
        this.cellStyleForNumber.setFont(font);
        this.cellStyleForDate.setFont(font);
        this.cellStyleForHyperlink.setFont(font);
        return this;
    }

    public DefaultStyleSet setWrapText() {
        this.cellStyle.setWrapText(true);
        this.cellStyleForNumber.setWrapText(true);
        this.cellStyleForDate.setWrapText(true);
        this.cellStyleForHyperlink.setWrapText(true);
        return this;
    }
}

