/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.style;

import java.io.Serializable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.miaixz.bus.core.xyz.ObjectKit;

public class CellBorderStyle
implements Serializable {
    private static final long serialVersionUID = -1L;
    private BorderStyle topStyle;
    private Short topColor;
    private BorderStyle rightStyle;
    private Short rightColor;
    private BorderStyle bottomStyle;
    private Short bottomColor;
    private BorderStyle leftStyle;
    private Short leftColor;

    public static CellBorderStyle of(CellStyle cellStyle) {
        return new CellBorderStyle().setTopStyle(cellStyle.getBorderTop()).setTopColor(cellStyle.getTopBorderColor()).setRightStyle(cellStyle.getBorderRight()).setRightColor(cellStyle.getRightBorderColor()).setBottomStyle(cellStyle.getBorderBottom()).setBottomColor(cellStyle.getBottomBorderColor()).setLeftStyle(cellStyle.getBorderLeft()).setLeftColor(cellStyle.getLeftBorderColor());
    }

    public static CellBorderStyle of(BorderStyle borderStyle, IndexedColors colorIndex) {
        return new CellBorderStyle().setTopStyle(borderStyle).setTopColor(colorIndex.getIndex()).setRightStyle(borderStyle).setRightColor(colorIndex.getIndex()).setBottomStyle(borderStyle).setBottomColor(colorIndex.getIndex()).setLeftStyle(borderStyle).setLeftColor(colorIndex.getIndex());
    }

    public BorderStyle getTopStyle() {
        return this.topStyle;
    }

    public CellBorderStyle setTopStyle(BorderStyle topStyle) {
        this.topStyle = topStyle;
        return this;
    }

    public Short getTopColor() {
        return this.topColor;
    }

    public CellBorderStyle setTopColor(Short topColor) {
        this.topColor = topColor;
        return this;
    }

    public BorderStyle getRightStyle() {
        return this.rightStyle;
    }

    public CellBorderStyle setRightStyle(BorderStyle rightStyle) {
        this.rightStyle = rightStyle;
        return this;
    }

    public Short getRightColor() {
        return this.rightColor;
    }

    public CellBorderStyle setRightColor(Short rightColor) {
        this.rightColor = rightColor;
        return this;
    }

    public BorderStyle getBottomStyle() {
        return this.bottomStyle;
    }

    public CellBorderStyle setBottomStyle(BorderStyle bottomStyle) {
        this.bottomStyle = bottomStyle;
        return this;
    }

    public Short getBottomColor() {
        return this.bottomColor;
    }

    public CellBorderStyle setBottomColor(Short bottomColor) {
        this.bottomColor = bottomColor;
        return this;
    }

    public BorderStyle getLeftStyle() {
        return this.leftStyle;
    }

    public CellBorderStyle setLeftStyle(BorderStyle leftStyle) {
        this.leftStyle = leftStyle;
        return this;
    }

    public Short getLeftColor() {
        return this.leftColor;
    }

    public CellBorderStyle setLeftColor(Short leftColor) {
        this.leftColor = leftColor;
        return this;
    }

    public CellStyle setTo(CellStyle cellStyle) {
        ObjectKit.accept((Object)this.topStyle, arg_0 -> ((CellStyle)cellStyle).setBorderTop(arg_0));
        ObjectKit.accept((Object)this.topColor, arg_0 -> ((CellStyle)cellStyle).setTopBorderColor(arg_0));
        ObjectKit.accept((Object)this.rightStyle, arg_0 -> ((CellStyle)cellStyle).setBorderRight(arg_0));
        ObjectKit.accept((Object)this.rightColor, arg_0 -> ((CellStyle)cellStyle).setRightBorderColor(arg_0));
        ObjectKit.accept((Object)this.bottomStyle, arg_0 -> ((CellStyle)cellStyle).setBorderBottom(arg_0));
        ObjectKit.accept((Object)this.bottomColor, arg_0 -> ((CellStyle)cellStyle).setBottomBorderColor(arg_0));
        ObjectKit.accept((Object)this.leftStyle, arg_0 -> ((CellStyle)cellStyle).setBorderLeft(arg_0));
        ObjectKit.accept((Object)this.leftColor, arg_0 -> ((CellStyle)cellStyle).setLeftBorderColor(arg_0));
        return cellStyle;
    }
}

