/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.shape;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.StreamKit;

public class ExcelShape {
    public static void writePicTo(Picture pic, File file) {
        ExcelShape.writePicTo(pic.getPictureData(), file);
    }

    public static void writePicTo(PictureData pic, File file) {
        FileKit.writeBytes((byte[])pic.getData(), (File)file);
    }

    public static List<? extends PictureData> getAllPictures(Workbook workbook) {
        return workbook.getAllPictures();
    }

    public static List<Picture> getShapePics(Workbook workbook, int sheetIndex) {
        Assert.notNull((Object)workbook, (String)"Workbook must be not null !", (Object[])new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        return ExcelShape.getShapePics(workbook.getSheetAt(sheetIndex));
    }

    public static List<Picture> getShapePics(Sheet sheet) {
        Assert.notNull((Object)sheet, (String)"Sheet must be not null !", (Object[])new Object[0]);
        Drawing drawing = sheet.getDrawingPatriarch();
        if (null == drawing) {
            return ListKit.empty();
        }
        return StreamKit.of((Iterable)drawing).filter(shape -> shape instanceof Picture).map(shape -> (Picture)shape).collect(Collectors.toList());
    }
}

