/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.reader;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.miaixz.bus.core.center.function.BiConsumerX;
import org.miaixz.bus.office.excel.cell.editors.CellEditor;
import org.miaixz.bus.office.excel.reader.AbstractSheetReader;
import org.miaixz.bus.office.excel.xyz.CellKit;

public class WalkSheetReader
extends AbstractSheetReader<Void> {
    private final BiConsumerX<Cell, Object> cellHandler;

    public WalkSheetReader(int startRowIndex, int endRowIndex, BiConsumerX<Cell, Object> cellHandler) {
        super(startRowIndex, endRowIndex);
        this.cellHandler = cellHandler;
    }

    @Override
    public Void read(Sheet sheet) {
        int startRowIndex = Math.max(this.cellRangeAddress.getFirstRow(), sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.cellRangeAddress.getLastRow(), sheet.getLastRowNum());
        CellEditor cellEditor = this.config.getCellEditor();
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = sheet.getRow(y);
            if (null == row) continue;
            short startColumnIndex = (short)Math.max(this.cellRangeAddress.getFirstColumn(), row.getFirstCellNum());
            short endColumnIndex = (short)Math.min(this.cellRangeAddress.getLastColumn(), row.getLastCellNum());
            for (short x = startColumnIndex; x < endColumnIndex; x = (short)(x + 1)) {
                Cell cell = CellKit.getCell(row, x);
                this.cellHandler.accept((Object)cell, CellKit.getCellValue(cell, cellEditor));
            }
        }
        return null;
    }
}

