/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.office.excel.reader.AbstractSheetReader;
import org.miaixz.bus.office.excel.xyz.RowKit;

public class MapSheetReader
extends AbstractSheetReader<List<Map<Object, Object>>> {
    private final int headerRowIndex;

    public MapSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex) {
        super(startRowIndex, endRowIndex);
        this.headerRowIndex = headerRowIndex;
    }

    @Override
    public List<Map<Object, Object>> read(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 0) {
            return ListKit.empty();
        }
        if (this.headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format((CharSequence)"Header row index {} is lower than first row index {}.", (Object[])new Object[]{this.headerRowIndex, firstRowNum}));
        }
        if (this.headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format((CharSequence)"Header row index {} is greater than last row index {}.", (Object[])new Object[]{this.headerRowIndex, lastRowNum}));
        }
        int startRowIndex = this.cellRangeAddress.getFirstRow();
        if (startRowIndex > lastRowNum) {
            return ListKit.empty();
        }
        startRowIndex = Math.max(startRowIndex, firstRowNum);
        int endRowIndex = Math.min(this.cellRangeAddress.getLastRow(), lastRowNum);
        List<Object> headerList = this.config.aliasHeader(this.readRow(sheet, this.headerRowIndex));
        ArrayList<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>(endRowIndex - startRowIndex + 1);
        boolean ignoreEmptyRow = this.config.isIgnoreEmptyRow();
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == this.headerRowIndex || !CollKit.isNotEmpty(rowList = this.readRow(sheet, i)) && ignoreEmptyRow) continue;
            result.add(IteratorKit.toMap(headerList, rowList, (boolean)true));
        }
        return result;
    }

    private List<Object> readRow(Sheet sheet, int rowIndex) {
        return RowKit.readRow(sheet.getRow(rowIndex), this.config.getCellEditor());
    }
}

