/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.reader;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.office.excel.cell.editors.CellEditor;
import org.miaixz.bus.office.excel.reader.AbstractSheetReader;
import org.miaixz.bus.office.excel.xyz.RowKit;

public class ListSheetReader
extends AbstractSheetReader<List<List<Object>>> {
    private final boolean aliasFirstLine;

    public ListSheetReader(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        super(startRowIndex, endRowIndex);
        this.aliasFirstLine = aliasFirstLine;
    }

    @Override
    public List<List<Object>> read(Sheet sheet) {
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        int startRowIndex = Math.max(this.cellRangeAddress.getFirstRow(), sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.cellRangeAddress.getLastRow(), sheet.getLastRowNum());
        CellEditor cellEditor = this.config.getCellEditor();
        boolean ignoreEmptyRow = this.config.isIgnoreEmptyRow();
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList = RowKit.readRow(sheet.getRow(i), cellEditor);
            if (!CollKit.isNotEmpty(rowList) && ignoreEmptyRow) continue;
            if (this.aliasFirstLine && i == startRowIndex) {
                rowList = this.config.aliasHeader(rowList);
            }
            resultList.add(rowList);
        }
        return resultList;
    }
}

