/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.reader;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.miaixz.bus.core.center.function.BiConsumerX;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.office.excel.ExcelBase;
import org.miaixz.bus.office.excel.ExcelExtractor;
import org.miaixz.bus.office.excel.reader.BeanSheetReader;
import org.miaixz.bus.office.excel.reader.ColumnSheetReader;
import org.miaixz.bus.office.excel.reader.ExcelReadConfig;
import org.miaixz.bus.office.excel.reader.ListSheetReader;
import org.miaixz.bus.office.excel.reader.MapSheetReader;
import org.miaixz.bus.office.excel.reader.SheetReader;
import org.miaixz.bus.office.excel.reader.WalkSheetReader;
import org.miaixz.bus.office.excel.writer.ExcelWriter;
import org.miaixz.bus.office.excel.xyz.CellKit;
import org.miaixz.bus.office.excel.xyz.ExcelKit;
import org.miaixz.bus.office.excel.xyz.RowKit;
import org.miaixz.bus.office.excel.xyz.WorkbookKit;

public class ExcelReader
extends ExcelBase<ExcelReader, ExcelReadConfig> {
    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileKit.file((String)excelFilePath), sheetIndex);
    }

    public ExcelReader(String excelFilePath, String sheetName) {
        this(FileKit.file((String)excelFilePath), sheetName);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorkbookKit.createBook(bookFile, true), sheetIndex);
        this.targetFile = bookFile;
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(WorkbookKit.createBook(bookFile, true), sheetName);
        this.targetFile = bookFile;
    }

    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(WorkbookKit.createBook(bookStream), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName) {
        this(WorkbookKit.createBook(bookStream), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(ExcelReader.getSheetOrCloseWorkbook(book, sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(ExcelReader.getSheetOrCloseWorkbook(book, sheetName));
    }

    public ExcelReader(Sheet sheet) {
        super(new ExcelReadConfig(), sheet);
    }

    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, String name) throws IllegalArgumentException {
        Sheet sheet;
        Assert.notNull((Object)workbook);
        if (null == name) {
            name = "sheet1";
        }
        if (null == (sheet = workbook.getSheet(name))) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw new IllegalArgumentException("Sheet [" + name + "] not exist!");
        }
        return sheet;
    }

    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, int sheetIndex) throws IllegalArgumentException {
        Sheet sheet;
        Assert.notNull((Object)workbook);
        try {
            sheet = workbook.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException e) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw e;
        }
        if (null == sheet) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw new IllegalArgumentException("Sheet at [" + sheetIndex + "] not exist!");
        }
        return sheet;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        return this.read(startRowIndex, endRowIndex, false);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        ListSheetReader reader = new ListSheetReader(startRowIndex, endRowIndex, aliasFirstLine);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return this.read(reader);
    }

    public List<Object> readColumn(int columnIndex, int startRowIndex) {
        return this.readColumn(columnIndex, startRowIndex, Integer.MAX_VALUE);
    }

    public List<Object> readColumn(int columnIndex, int startRowIndex, int endRowIndex) {
        ColumnSheetReader reader = new ColumnSheetReader(columnIndex, startRowIndex, endRowIndex);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return this.read(reader);
    }

    public void read(BiConsumerX<Cell, Object> cellHandler) {
        this.read(0, Integer.MAX_VALUE, cellHandler);
    }

    public void read(int startRowIndex, int endRowIndex, BiConsumerX<Cell, Object> cellHandler) {
        this.checkClosed();
        WalkSheetReader reader = new WalkSheetReader(startRowIndex, endRowIndex, cellHandler);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        reader.read(this.sheet);
    }

    public List<Map<Object, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<Object, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        MapSheetReader reader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return this.read(reader);
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        BeanSheetReader<T> reader = new BeanSheetReader<T>(headerRowIndex, startRowIndex, endRowIndex, beanType);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return (List)this.read(reader);
    }

    public <T> T read(SheetReader<T> sheetReader) {
        this.checkClosed();
        return ((SheetReader)Assert.notNull(sheetReader)).read(this.sheet);
    }

    public String readAsText(boolean withSheetName) {
        return ExcelExtractor.readAsText(this.workbook, withSheetName);
    }

    public org.apache.poi.ss.extractor.ExcelExtractor getExtractor() {
        return ExcelExtractor.getExtractor(this.workbook);
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return CellKit.getCellValue(this.getCell(x, y), ((ExcelReadConfig)this.config).getCellEditor());
    }

    public ExcelWriter getWriter() {
        if (null == this.targetFile) {
            return new ExcelWriter(this.sheet);
        }
        return ExcelKit.getWriter(this.targetFile, this.sheet.getSheetName());
    }

    private List<Object> readRow(Row row) {
        return RowKit.readRow(row, ((ExcelReadConfig)this.config).getCellEditor());
    }
}

