/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.reader;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.miaixz.bus.office.excel.cell.editors.CellEditor;
import org.miaixz.bus.office.excel.reader.AbstractSheetReader;
import org.miaixz.bus.office.excel.xyz.CellKit;

public class ColumnSheetReader
extends AbstractSheetReader<List<Object>> {
    public ColumnSheetReader(int columnIndex, int startRowIndex, int endRowIndex) {
        super(new CellRangeAddress(startRowIndex, endRowIndex, columnIndex, columnIndex));
    }

    @Override
    public List<Object> read(Sheet sheet) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        int startRowIndex = Math.max(this.cellRangeAddress.getFirstRow(), sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.cellRangeAddress.getLastRow(), sheet.getLastRowNum());
        int columnIndex = this.cellRangeAddress.getFirstColumn();
        CellEditor cellEditor = this.config.getCellEditor();
        boolean ignoreEmptyRow = this.config.isIgnoreEmptyRow();
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            Object value = CellKit.getCellValue(CellKit.getCell(sheet.getRow(i), columnIndex), cellEditor);
            if (null == value && ignoreEmptyRow) continue;
            resultList.add(value);
        }
        return resultList;
    }
}

