/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.miaixz.bus.core.bean.copier.CopyOptions;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.office.excel.reader.ExcelReadConfig;
import org.miaixz.bus.office.excel.reader.MapSheetReader;
import org.miaixz.bus.office.excel.reader.SheetReader;

public class BeanSheetReader<T>
implements SheetReader<List<T>> {
    private final Class<T> beanClass;
    private final MapSheetReader mapSheetReader;

    public BeanSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanClass) {
        this.mapSheetReader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        this.beanClass = beanClass;
    }

    @Override
    public List<T> read(Sheet sheet) {
        Object mapList = this.mapSheetReader.read(sheet);
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return mapList;
        }
        ArrayList<Object> beanList = new ArrayList<Object>(mapList.size());
        CopyOptions copyOptions = CopyOptions.of().setIgnoreError(true);
        Iterator iterator = mapList.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            beanList.add(BeanKit.toBean((Object)map, this.beanClass, (CopyOptions)copyOptions));
        }
        return beanList;
    }

    public void setExcelConfig(ExcelReadConfig config) {
        this.mapSheetReader.setExcelConfig(config);
    }
}

