/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.cell.values;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.miaixz.bus.office.excel.cell.NullCell;
import org.miaixz.bus.office.excel.cell.editors.CellEditor;
import org.miaixz.bus.office.excel.cell.values.CellValue;
import org.miaixz.bus.office.excel.cell.values.ErrorCellValue;
import org.miaixz.bus.office.excel.cell.values.NumericCellValue;
import org.miaixz.bus.office.excel.xyz.CellKit;

public class CompositeCellValue
implements CellValue<Object> {
    private final Cell cell;
    private final CellType cellType;
    private final CellEditor cellEditor;

    public CompositeCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        this.cell = cell;
        this.cellType = cellType;
        this.cellEditor = cellEditor;
    }

    public static CompositeCellValue of(Cell cell, CellType cellType, CellEditor cellEditor) {
        return new CompositeCellValue(cell, cellType, cellEditor);
    }

    @Override
    public Object getValue() {
        Cell mergedCell;
        Cell cell = this.cell;
        CellType cellType = this.cellType;
        CellEditor cellEditor = this.cellEditor;
        if (null == cell) {
            return null;
        }
        if (cell instanceof NullCell) {
            return null == cellEditor ? null : cellEditor.edit(cell, null);
        }
        if (null == cellType) {
            cellType = cell.getCellType();
        }
        if ((mergedCell = CellKit.getFirstCellOfMerged(cell)) != cell) {
            cell = mergedCell;
            cellType = cell.getCellType();
        }
        Object value = switch (cellType) {
            case CellType.NUMERIC -> new NumericCellValue(cell).getValue();
            case CellType.BOOLEAN -> cell.getBooleanCellValue();
            case CellType.FORMULA -> CompositeCellValue.of(cell, cell.getCachedFormulaResultType(), cellEditor).getValue();
            case CellType.BLANK -> "";
            case CellType.ERROR -> new ErrorCellValue(cell).getValue();
            default -> cell.getStringCellValue();
        };
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }
}

