/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.cell.setters;

import java.io.File;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.office.excel.SimpleAnchor;
import org.miaixz.bus.office.excel.cell.setters.CellSetter;
import org.miaixz.bus.office.excel.shape.ExcelPictureType;
import org.miaixz.bus.office.excel.writer.ExcelDrawing;

public class PictureCellSetter
implements CellSetter {
    private final byte[] pictureData;
    private final ExcelPictureType pictureType;

    public PictureCellSetter(byte[] pictureData) {
        this(pictureData, ExcelPictureType.PNG);
    }

    public PictureCellSetter(File picturefile) {
        this(FileKit.readBytes((File)picturefile), ExcelPictureType.getType(picturefile));
    }

    public PictureCellSetter(byte[] pictureData, ExcelPictureType pictureType) {
        this.pictureData = pictureData;
        this.pictureType = pictureType;
    }

    @Override
    public void setValue(Cell cell) {
        Sheet sheet = cell.getSheet();
        int columnIndex = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        ExcelDrawing.drawingPicture(sheet, this.pictureData, this.pictureType, new SimpleAnchor(columnIndex, rowIndex, columnIndex + 1, rowIndex + 1));
    }
}

