/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.cell.setters;

import java.io.File;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.miaixz.bus.office.excel.cell.setters.BooleanCellSetter;
import org.miaixz.bus.office.excel.cell.setters.CalendarCellSetter;
import org.miaixz.bus.office.excel.cell.setters.CellSetter;
import org.miaixz.bus.office.excel.cell.setters.CharSequenceCellSetter;
import org.miaixz.bus.office.excel.cell.setters.DateCellSetter;
import org.miaixz.bus.office.excel.cell.setters.HyperlinkCellSetter;
import org.miaixz.bus.office.excel.cell.setters.NullCellSetter;
import org.miaixz.bus.office.excel.cell.setters.NumberCellSetter;
import org.miaixz.bus.office.excel.cell.setters.PictureCellSetter;
import org.miaixz.bus.office.excel.cell.setters.RichTextCellSetter;
import org.miaixz.bus.office.excel.cell.setters.TemporalAccessorCellSetter;

public class CellSetterFactory {
    public static CellSetter createCellSetter(Object value) {
        if (null == value) {
            return NullCellSetter.INSTANCE;
        }
        if (value instanceof CellSetter) {
            return (CellSetter)value;
        }
        if (value instanceof Date) {
            return new DateCellSetter((Date)value);
        }
        if (value instanceof TemporalAccessor) {
            return new TemporalAccessorCellSetter((TemporalAccessor)value);
        }
        if (value instanceof Calendar) {
            return new CalendarCellSetter((Calendar)value);
        }
        if (value instanceof Boolean) {
            return new BooleanCellSetter((Boolean)value);
        }
        if (value instanceof RichTextString) {
            return new RichTextCellSetter((RichTextString)value);
        }
        if (value instanceof Number) {
            return new NumberCellSetter((Number)value);
        }
        if (value instanceof Hyperlink) {
            return new HyperlinkCellSetter((Hyperlink)value);
        }
        if (value instanceof byte[]) {
            return new PictureCellSetter((byte[])value);
        }
        if (value instanceof File) {
            return new PictureCellSetter((File)value);
        }
        return new CharSequenceCellSetter(value.toString());
    }
}

