/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.excel.cell;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.miaixz.bus.office.excel.xyz.CellKit;

public class MergedCell {
    private final Cell first;
    private final CellRangeAddress range;

    public MergedCell(Cell first, CellRangeAddress range) {
        this.first = first;
        this.range = range;
    }

    public static MergedCell of(Cell cell, int rowCount, int columnCount) {
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        return MergedCell.of(cell, new CellRangeAddress(rowIndex, rowIndex + rowCount - 1, columnIndex, columnIndex + columnCount - 1));
    }

    public static MergedCell of(Cell cell, CellRangeAddress range) {
        return new MergedCell(cell, range);
    }

    public Cell getFirst() {
        return this.first;
    }

    public CellRangeAddress getRange() {
        return this.range;
    }

    public MergedCell setCellStyle(CellStyle cellStyle) {
        this.first.setCellStyle(cellStyle);
        return this;
    }

    public MergedCell setValue(Object value) {
        CellKit.setCellValue(this.first, value);
        return this;
    }
}

