/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.csv;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.center.iterator.ArrayIterator;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.office.csv.CsvData;
import org.miaixz.bus.office.csv.CsvWriteConfig;

public final class CsvWriter
implements Closeable,
Flushable,
Serializable {
    private static final long serialVersionUID = -1L;
    private final Writer writer;
    private final CsvWriteConfig config;
    private boolean newline = true;
    private boolean isFirstLine = true;

    public CsvWriter(String filePath) {
        this(FileKit.file((String)filePath));
    }

    public CsvWriter(File file) {
        this(file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public CsvWriter(String filePath, Charset charset) {
        this(FileKit.file((String)filePath), charset);
    }

    public CsvWriter(File file, Charset charset) {
        this(file, charset, false);
    }

    public CsvWriter(String filePath, Charset charset, boolean isAppend) {
        this(FileKit.file((String)filePath), charset, isAppend);
    }

    public CsvWriter(File file, Charset charset, boolean isAppend) {
        this(file, charset, isAppend, null);
    }

    public CsvWriter(String filePath, Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileKit.file((String)filePath), charset, isAppend, config);
    }

    public CsvWriter(File file, Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileKit.getWriter((File)file, (Charset)charset, (boolean)isAppend), isAppend ? (config == null ? CsvWriteConfig.defaultConfig().setEndingLineBreak(true) : config.setEndingLineBreak(true)) : config);
    }

    public CsvWriter(Writer writer) {
        this(writer, null);
    }

    public CsvWriter(Writer writer, CsvWriteConfig config) {
        this.writer = writer instanceof BufferedWriter ? writer : new BufferedWriter(writer);
        this.config = (CsvWriteConfig)ObjectKit.defaultIfNull((Object)config, CsvWriteConfig::defaultConfig);
    }

    private static boolean isDDEUnsafeChar(char c) {
        return c == '@' || c == '+' || c == '-' || c == '=';
    }

    public CsvWriter setAlwaysDelimitText(boolean alwaysDelimitText) {
        this.config.setAlwaysDelimitText(alwaysDelimitText);
        return this;
    }

    public CsvWriter setLineDelimiter(char[] lineDelimiter) {
        this.config.setLineDelimiter(lineDelimiter);
        return this;
    }

    public CsvWriter setDdeSafe(boolean ddeSafe) {
        this.config.setDdeSafe(ddeSafe);
        return this;
    }

    public CsvWriter write(String[] ... lines) throws InternalException {
        return this.write((Iterable<?>)new ArrayIterator((Object[])lines));
    }

    public CsvWriter write(Iterable<?> lines) throws InternalException {
        if (CollKit.isNotEmpty(lines)) {
            for (Object values : lines) {
                this.appendLine(Convert.toStringArray(values));
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter write(CsvData csvData) {
        if (csvData != null) {
            List<String> header = csvData.getHeader();
            if (CollKit.isNotEmpty(header)) {
                this.writeHeaderLine(header.toArray(new String[0]));
            }
            this.write(csvData.getRows());
            this.flush();
        }
        return this;
    }

    public CsvWriter writeBeans(Iterable<?> beans, String ... properties) {
        return this.writeBeans(beans, true, properties);
    }

    public CsvWriter writeBeans(Iterable<?> beans, boolean writeHeaderLine, String ... properties) {
        if (CollKit.isNotEmpty(beans)) {
            boolean isFirst = writeHeaderLine;
            for (Object bean : beans) {
                Map map = BeanKit.beanToMap(bean, (String[])properties);
                if (isFirst) {
                    this.writeHeaderLine(map.keySet().toArray(new String[0]));
                    isFirst = false;
                }
                this.writeLine(Convert.toStringArray(map.values()));
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter writeHeaderLine(String ... fields) throws InternalException {
        Map headerAlias = this.config.headerAlias;
        if (MapKit.isNotEmpty((Map)headerAlias)) {
            for (int i = 0; i < fields.length; ++i) {
                String alias = (String)headerAlias.get(fields[i]);
                if (null == alias) continue;
                fields[i] = alias;
            }
        }
        return this.writeLine(fields);
    }

    public CsvWriter writeLine(String ... fields) throws InternalException {
        if (ArrayKit.isEmpty((Object[])fields)) {
            return this.writeLine();
        }
        this.appendLine(fields);
        return this;
    }

    public CsvWriter writeLine() throws InternalException {
        try {
            this.writer.write(this.config.lineDelimiter);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        this.newline = true;
        return this;
    }

    public CsvWriter writeComment(String comment) {
        Assert.notNull((Object)this.config.commentCharacter, (String)"Comment is disable!", (Object[])new Object[0]);
        try {
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            this.writer.write(this.config.commentCharacter.charValue());
            this.writer.write(comment);
            this.newline = true;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        if (this.config.endingLineBreak) {
            this.writeLine();
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.writer});
    }

    @Override
    public void flush() throws InternalException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private void appendLine(String ... fields) throws InternalException {
        try {
            this.doAppendLine(fields);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private void doAppendLine(String ... fields) throws IOException {
        if (null != fields) {
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            for (String field : fields) {
                this.appendField(field);
            }
            this.newline = true;
        }
    }

    private void appendField(String value) throws IOException {
        boolean alwaysDelimitText = this.config.alwaysDelimitText;
        char textDelimiter = this.config.textDelimiter;
        char fieldSeparator = this.config.fieldSeparator;
        if (!this.newline) {
            this.writer.write(fieldSeparator);
        } else {
            this.newline = false;
        }
        if (null == value) {
            if (alwaysDelimitText) {
                this.writer.write(new char[]{textDelimiter, textDelimiter});
            }
            return;
        }
        char[] valueChars = value.toCharArray();
        boolean needsTextDelimiter = alwaysDelimitText;
        boolean containsTextDelimiter = false;
        for (char c : valueChars) {
            if (c == textDelimiter) {
                needsTextDelimiter = true;
                containsTextDelimiter = true;
                break;
            }
            if (c != fieldSeparator && c != '\n' && c != '\r') continue;
            needsTextDelimiter = true;
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
        if (this.config.ddeSafe && CsvWriter.isDDEUnsafeChar(valueChars[0])) {
            this.writer.write(39);
        }
        if (containsTextDelimiter) {
            for (char c : valueChars) {
                if (c == textDelimiter) {
                    this.writer.write(textDelimiter);
                }
                this.writer.write(c);
            }
        } else {
            this.writer.write(valueChars);
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
    }
}

