/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office.csv;

import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.office.csv.CsvData;
import org.miaixz.bus.office.csv.CsvParser;
import org.miaixz.bus.office.csv.CsvReadConfig;
import org.miaixz.bus.office.csv.CsvRow;

public class CsvBaseReader
implements Serializable {
    protected static final Charset DEFAULT_CHARSET = org.miaixz.bus.core.lang.Charset.UTF_8;
    private static final long serialVersionUID = -1L;
    private final CsvReadConfig config;

    public CsvBaseReader() {
        this(null);
    }

    public CsvBaseReader(CsvReadConfig config) {
        this.config = (CsvReadConfig)ObjectKit.defaultIfNull((Object)config, CsvReadConfig::of);
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.config.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws InternalException {
        return this.read(file, DEFAULT_CHARSET);
    }

    public CsvData readFromString(String csvStr) {
        return this.read(new StringReader(csvStr), true);
    }

    public void readFromString(String csvStr, ConsumerX<CsvRow> rowHandler) {
        this.read(this.parse(new StringReader(csvStr)), true, rowHandler);
    }

    public CsvData read(File file, Charset charset) throws InternalException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) throws InternalException {
        return this.read(path, DEFAULT_CHARSET);
    }

    public CsvData read(Path path, Charset charset) throws InternalException {
        Assert.notNull((Object)path, (String)"path must not be null", (Object[])new Object[0]);
        return this.read(PathResolve.getReader((Path)path, (Charset)charset), true);
    }

    public CsvData read(Reader reader, boolean closeReader) throws InternalException {
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        this.read(csvParser, closeReader, (ConsumerX<CsvRow>)((ConsumerX & Serializable)rows::add));
        List<String> header = this.config.headerLineNo > -1L ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    public List<Map<String, String>> readMapList(Reader reader, boolean closeReader) throws InternalException {
        this.config.setContainsHeader(true);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        this.read(reader, closeReader, (ConsumerX<CsvRow>)(ConsumerX & Serializable)row -> result.add(row.getFieldMap()));
        return result;
    }

    public <T> List<T> read(Reader reader, boolean closeReader, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read(reader, closeReader, (ConsumerX<CsvRow>)(ConsumerX & Serializable)row -> result.add(row.toBean(clazz)));
        return result;
    }

    public <T> List<T> read(String csvStr, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read((Reader)new StringReader(csvStr), true, (ConsumerX<CsvRow>)(ConsumerX & Serializable)row -> result.add(row.toBean(clazz)));
        return result;
    }

    public void read(Reader reader, boolean closeReader, ConsumerX<CsvRow> rowHandler) throws InternalException {
        this.read(this.parse(reader), closeReader, rowHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read(CsvParser csvParser, boolean closeParser, ConsumerX<CsvRow> rowHandler) throws InternalException {
        try {
            while (csvParser.hasNext()) {
                rowHandler.accept((Object)((CsvRow)((Object)csvParser.next())));
            }
            if (!closeParser) return;
        }
        catch (Throwable throwable) {
            if (!closeParser) throw throwable;
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{csvParser});
            throw throwable;
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{csvParser});
    }

    protected CsvParser parse(Reader reader) throws InternalException {
        return new CsvParser(reader, this.config);
    }
}

