/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.office;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Builder {
    public static final String XLS_CONTENT_TYPE = "application/vnd.ms-excel";
    public static final String XLSX_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String NO_POI_ERROR_MSG = "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0";
    private static final int[] CUSTOM_FORMATS = new int[]{28, 30, 31, 32, 33, 55, 56, 57, 58};

    public static boolean isDateFormat(Cell cell) {
        return Builder.isDateFormat(cell, null);
    }

    public static boolean isDateFormat(Cell cell, ConditionalFormattingEvaluator cfEvaluator) {
        ExcelNumberFormat nf = ExcelNumberFormat.from((Cell)cell, (ConditionalFormattingEvaluator)cfEvaluator);
        return Builder.isDateFormat(nf);
    }

    public static boolean isDateFormat(ExcelNumberFormat numFmt) {
        return Builder.isDateFormat(numFmt.getIdx(), numFmt.getFormat());
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        if (ArrayKit.contains((int[])CUSTOM_FORMATS, (int)formatIndex)) {
            return true;
        }
        if (StringKit.isNotEmpty((CharSequence)formatString) && StringKit.containsAny((CharSequence)formatString, (CharSequence[])new CharSequence[]{"\u5468", "\u661f\u671f", "aa"})) {
            return true;
        }
        return DateUtil.isADateFormat((int)formatIndex, (String)formatString);
    }

    public static boolean isXls(InputStream in) {
        return FileMagic.OLE2 == Builder.getFileMagic(in);
    }

    public static boolean isXlsx(InputStream in) {
        return FileMagic.OOXML == Builder.getFileMagic(in);
    }

    public static boolean isXlsx(File file) {
        try {
            return FileMagic.valueOf((File)file) == FileMagic.OOXML;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private static FileMagic getFileMagic(InputStream in) {
        FileMagic magic;
        in = FileMagic.prepareToCheckMagic((InputStream)in);
        try {
            magic = FileMagic.valueOf((InputStream)in);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return magic;
    }
}

