(ns ${artifactId}.system
  (:require [system.core :refer [defsystem]]
            [com.stuartsierra.component :as component]
            [system.components
             [endpoint :refer [new-endpoint]]
             [repl-server :refer [new-repl-server]]
             [sente :refer [new-channel-socket-server sente-routes]]
             [undertow :refer [new-undertow]]
             [handler :refer [new-handler]]]
            [taoensso.sente.server-adapters.community.undertow :refer [get-sch-adapter]]            
            [${artifactId}.handler :refer [sente-handler bidi-routes default-handler middleware file-upload]]))

(defsystem base
  [:sente (new-channel-socket-server :handler sente-handler :adapter (get-sch-adapter) :options {})
   :sente-endpoint (component/using (new-endpoint :routes sente-routes) [:sente])
   :bidi-endpoint (new-endpoint :routes bidi-routes)
   :file-upload (new-endpoint :routes file-upload)
   :handler (component/using (new-handler :default-handler default-handler :options {:middleware middleware}) [:sente-endpoint :bidi-endpoint :file-upload]) 
   :http (component/using (new-undertow :port (Integer. ^String (System/getProperty "http.port"))) [:handler])])

(defn prod
  "Assembles and returns components for a production deployment"
  []
  (merge (base)
         (component/system-map
          :repl-server (new-repl-server :port (Integer. (System/getProperty "repl.port")) :bind (System/getProperty "repl.ip") :with-cider false)
          :cider-repl-server (new-repl-server :port (inc (Integer. (System/getProperty "repl.port"))) :bind (System/getProperty "repl.ip") :with-cider true))))


