(ns ${artifactId}.handler
    (:require
     [reitit.ring :as ring]
            [clojure.java.io :as io]
            [ring.util.response :refer [response content-type]]
            [ring.middleware.defaults :refer [site-defaults wrap-defaults]]
            [muuntaja.middleware :refer [wrap-params wrap-format]]
            [ring.middleware.session.memory :as memory]
            [${artifactId}.routing-table :refer [routes]]
            [${artifactId}.html :as html]
            [clojure.core.match :refer [match]]
            [clojure.tools.logging :as log]))

(def bidi-routes
  (let [index (fn [req] (-> (html/index req)
                          response
                          (content-type "text/html")))]
    (into [] (for [[r1 r2] routes] [r1 (assoc r2 :get index)]))))

(defn file-upload [_]
  (ring/router ["/upload" {:post {:handler (fn [req]
                                             (let [inputstream (:body req)
                                                   filename (get-in req [:headers "content-name"] )
                                                   path (System/getProperty "java.io.tmpdir")
                                                   outputfile (io/file (str path "/" filename))]
                                               (log/debug "Received " filename)
                                               (io/copy inputstream outputfile)
                                               {:status 200
                                                :body {:filename filename}}))}}]))

(defn default-handler [_]
  (ring/routes
    (ring/create-resource-handler {:path "/" :root ""})
    (ring/create-default-handler)))

(def defaults (let [store (memory/memory-store)]
                (-> site-defaults
                   (assoc-in [:session :store] store))))

(def middleware [[wrap-defaults defaults]
                 wrap-format
                 wrap-params])

(defn sente-handler [component]
  (fn [{:as ev-msg :keys [event id ?data send-fn ?reply-fn uid ring-req client-id]}]
    (let [session (:session ring-req)
          headers (:headers ring-req)
          [id data :as ev] event]

      (when (and uid (not= event [:chsk/ws-ping])) (log/debug (:uri ring-req) event))

      (match [id data]
             [:chsk/uidport-close uid] (log/debug "browser tab closed" uid)
             [:websocket/api {:increment count}] (?reply-fn {:count (inc count)})
             [:websocket/api {:new-user _}] (?reply-fn {:user-name "Gary Sussman"
                                                        :born "1947"
                                                        :bio "Gerald Jay Sussman is the Panasonic Professor of Electrical Engineering at the Massachusetts Institute of Technology (MIT)."})
             [:websocket/api {:get-xs _}] (?reply-fn {:xs [{:name "Lisp" :id 1}
                                                           {:name "Scheme" :id 2}
                                                           {:name "Racket" :id 3}]})
             [:websocket/api {:get-x x}] (case x
                                           "1" (?reply-fn {:name "Lisp" :quantity 13 :description "A computer language with parentheses" :id 1})
                                           "2" (?reply-fn {:name "Scheme" :quantity 22 :description "A computer language with parentheses" :id 2})
                                           "3" (?reply-fn {:name "Racket" :quantity 42 :description "A computer language with parentheses" :id 3})
                                           (?reply-fn {:name "unkown" :quantity 0 :id 0}))
             :else nil))))



