/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.mazarineblue.datasources.exceptions.IllegalMethodException;
import org.mazarineblue.datasources.exceptions.IllegalMethodParameterTypesException;
import org.mazarineblue.datasources.exceptions.IllegalMethodPostfixException;
import org.mazarineblue.datasources.exceptions.IllegalMethodReturnTypeException;

public class MethodSignature {
    private final String expectedPostfix;
    private Class[] expectedAnnotationTypes = new Class[0];
    private Class expectedReturnType = Void.TYPE;
    private Class[] expectedParameterTypes = new Class[0];

    public MethodSignature() {
        this("");
    }

    public MethodSignature(String postfix) {
        this.expectedPostfix = postfix;
    }

    public String getPostfix() {
        return this.expectedPostfix;
    }

    public void setAnnotationTypes(Class ... annotationTypes) {
        this.expectedAnnotationTypes = Arrays.copyOf(annotationTypes, annotationTypes.length);
    }

    public void setReturnType(Class returnType) {
        this.expectedReturnType = returnType;
    }

    public void setParameterTypes(Class ... parameterTypes) {
        this.expectedParameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
    }

    public boolean isMethod(Method method) throws IllegalMethodException {
        String name = method.getName();
        if (!this.equalsAnnotations(method)) {
            return false;
        }
        if (!name.endsWith(this.expectedPostfix)) {
            throw new IllegalMethodPostfixException(method, this);
        }
        if (!this.equalsParameterTypes(method)) {
            throw new IllegalMethodParameterTypesException(method, this);
        }
        if (!this.equalsReturnTypes(method)) {
            throw new IllegalMethodReturnTypeException(method, this);
        }
        return true;
    }

    private boolean equalsAnnotations(Method method) {
        Annotation[] annotations;
        boolean[] flags = this.createFlags();
        for (Annotation annocation : annotations = method.getDeclaredAnnotations()) {
            Class<? extends Annotation> actual = annocation.annotationType();
            for (int i = 0; i < this.expectedAnnotationTypes.length; ++i) {
                if (!this.expectedAnnotationTypes[i].equals(actual)) continue;
                flags[i] = true;
            }
        }
        return this.andFlags(flags);
    }

    private boolean[] createFlags() {
        boolean[] flags = new boolean[this.expectedAnnotationTypes.length];
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = false;
        }
        return flags;
    }

    private boolean andFlags(boolean[] flags) {
        for (boolean flag : flags) {
            if (flag) continue;
            return false;
        }
        return true;
    }

    private boolean equalsParameterTypes(Method method) {
        return Arrays.equals(method.getParameterTypes(), this.expectedParameterTypes);
    }

    private boolean equalsReturnTypes(Method method) {
        Class<?> actualReturnType = method.getReturnType();
        return this.expectedReturnType == actualReturnType;
    }
}

