/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import java.util.HashSet;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

public class SourceChain
implements DataSource {
    private DataSource source;
    private SourceChain next;

    public SourceChain() {
    }

    public SourceChain(DataSource source) {
        this.source = source;
    }

    public SourceChain(DataSource source, SourceChain next) {
        this.source = source;
        this.next = next;
    }

    public SourceChain(DataSource ... sources) {
        this.link(sources);
    }

    public SourceChain link(DataSource ... sources) {
        SourceChain chain = this;
        for (DataSource source : sources) {
            chain = chain.link(source);
        }
        return chain;
    }

    public SourceChain link(DataSource source) {
        if (this.source == null) {
            this.source = source;
            return this;
        }
        this.next = new SourceChain(source, this.next);
        return this.next;
    }

    public SourceChain lastLink() {
        return this.next == null ? this : this.next.lastLink();
    }

    @Override
    public boolean hasNext() {
        boolean found = this.source.hasNext();
        if (found) {
            return found;
        }
        return this.next == null ? false : this.next.hasNext();
    }

    @Override
    public String next() {
        String first = this.source.next();
        String second = this.next == null ? null : this.next.next();
        return first != null && !first.equals("") ? first : second;
    }

    @Override
    public String reset() {
        String first = this.source.reset();
        String second = null;
        if (this.next != null) {
            second = this.next.reset();
        }
        if (first == null || first.isEmpty()) {
            return second;
        }
        return first;
    }

    @Override
    public String getSourceIdentifier() {
        String identifier = this.source.getSourceIdentifier();
        if (this.next == null) {
            return identifier;
        }
        identifier = identifier + ", " + this.next.getSourceIdentifier();
        return identifier;
    }

    @Override
    public String getLineIdentifier() throws IllegalSourceStateException {
        String found = this.source.getLineIdentifier();
        if (found != null && !found.equals("")) {
            return found;
        }
        return this.next == null ? null : this.next.getLineIdentifier();
    }

    @Override
    public Object getData(String column) throws IllegalSourceStateException {
        Object obj = this.source.getData(column);
        if (obj != null) {
            return obj;
        }
        return this.next == null ? null : this.next.getData(column);
    }

    @Override
    public Object getData(int index) throws IllegalSourceStateException {
        Object obj = this.source.getData(index);
        if (obj != null) {
            return obj;
        }
        return this.next == null ? null : this.next.getData(index);
    }

    @Override
    public boolean setData(String column, Object value) throws Exception {
        if (this.source.setData(column, value)) {
            return true;
        }
        return this.next == null ? false : this.next.setData(column, value);
    }

    @Override
    public boolean setData(int index, Object value) {
        if (this.source.setData(index, value)) {
            return true;
        }
        return this.next == null ? false : this.next.setData(index, value);
    }

    @Override
    public String[] getColumns() {
        HashSet<String> set = new HashSet<String>();
        SourceChain current = this;
        while (current != null) {
            for (String column : this.source.getColumns()) {
                set.add(column);
            }
            current = this.next;
        }
        return set.toArray(new String[0]);
    }
}

